#ifndef __IOTDATAMESSAGEPART_HPP__
#define __IOTDATAMESSAGEPART_HPP__

#include <vector>

#include "Context.h"

#include "DataMessagePart.hpp"
class ChannelValue;


namespace misnet {
    class IOTDataMessagePart;
}


// This class describes the IOT data part of a message.
// It consists in a sequence of channel value blocks, one per channel.
// A 16-bit MAC is appended after the last channel value block.
class misnet::IOTDataMessagePart : virtual DataMessagePart {
    public:

    private:
        vector<ChannelValue>        _channelValues; // Vector of channel values
        uint16_t                    _mic;           // Message Authentication Code
};

#endif  // __IOTDATAMESSAGEPART_HPP__
