/*
 * MISNet   
 *
 *  Frame:   External Memory
 *
 *  Created on: August 17, 2018         Author: Francis CHATAIN
 *
 */
#ifndef __EXTMEMORY_HPP__
#define __EXTMEMORY_HPP__

#include "Context.h"

#include "DataBase.hpp"

namespace misnet {
    class ExtMemory;

// --------------------------------------------------------------------------------
// POUR INFORMATION : structure memoire de l'entete et d'une description de channel
// Non verifie actuellement !
// --------------------------------------------------------------------------------

    /* Header definition */
    typedef struct {
        uint8_t     memory_scheme_version;
        uint8_t     terminal_type;
        uint16_t    payload_id;
        uint8_t     nb_of_services;
        char        checksum[4];
        uint8_t     operating_mode;
        uint16_t    platform_base_period;
        uint16_t    payload_base_period;
        uint16_t    synchro_period;
        uint16_t    listen_period;
        uint16_t    listen_duration;
        char        comment[25];
    } Header;

    /* Service definition */
    typedef struct {
        uint8_t     rank;
        uint8_t     value_type;
        uint8_t     service_type;
        uint8_t     component_id;
        // uint8_t     value_type;      FC to compile
        uint8_t     component_group;
        uint8_t     service_state;
        uint8_t     access_type;
        uint8_t     request_mode;
        uint8_t     up_mode;
        double      subsample_rate;
        double      threshold_delta;
        double      high_threshold;
        double      low_threshold;
        char        action;
        char        output;
        char        comment[7];
    } ServiceDefinition;
}


// =======================================  Class content 
class misnet::ExtMemory 
{
    // Public variable /method 
    public:
        static void read (DataBase * dataBase) ;

    // Private variable /method 
    private:

    // Protected variable /method 
    protected:
      
} ;

#endif
