/*
 * MISNet   
 *
 *  Frame:   Gestionnaire de fabrication des messages et décodage des messages recus 
 *
 *  Created on: August 17, 2018       Author: Francis CHATAIN
 *
 */

// =====================================  Includes

//#include "main.h"
#include "DataBase.hpp"


using namespace misnet;


// =====================================  Method of class


// =====================================  Constructor 
DataBase::DataBase () {} 
DataBase::~DataBase () {} 

void DataBase::init () {}


#ifndef TEST_ENVIRONMENT
void DataBase::getRadioParameter (uint32_t              &rfFrequency, 
                        RadioLoRaBandwidths_t           &loraBw,
                        RadioLoRaSpreadingFactors_t     &loraSf ,
                        int8_t                          &txOutputPower,
                        uint8_t                         &bufferSizeMax,
                        int16_t                         &terminal_heartbeat_period,
                        int16_t                         &payload_heartbeat_period)
{                            
    rfFrequency                 =    _rf_frequency           ;   
    loraBw                      =    _lora_bw                ;   
    loraSf                      =    _lora_sf                ;   
    txOutputPower               =    _tx_output_power        ;   
    bufferSizeMax               =    _buffer_size_max        ;   
    terminal_heartbeat_period   =    _terminal_heartbeat_period;   
    payload_heartbeat_period    =    _payload_heartbeat_period;   
}


void DataBase::setRadioParameter ( uint32_t             rfFrequency, 
                        RadioLoRaBandwidths_t           loraBw,
                        RadioLoRaSpreadingFactors_t     loraSf ,
                        int8_t                          txOutputPower,
                        uint8_t                         bufferSizeMax,
                        int16_t                         terminal_heartbeat_period,
                        int16_t                         payload_heartbeat_period)
{
    _rf_frequency = rfFrequency   ;
    _lora_bw = loraBw             ;
    _lora_sf = loraSf             ;
    _tx_output_power = txOutputPower      ;
    _buffer_size_max  = bufferSizeMax     ;
    _terminal_heartbeat_period  = terminal_heartbeat_period   ;
    _payload_heartbeat_period  = payload_heartbeat_period   ;

     printf( "*** DTB ***  setRadioParameter   %u %d %d %d %d %d %d\r\n", _rf_frequency, _lora_bw,
     _lora_sf, _tx_output_power, _buffer_size_max,_terminal_heartbeat_period, _payload_heartbeat_period);
}
#endif


short DataBase::getNbService(Service::DEVICE_TYPE deviceType) {
    short result = 0;

    std::vector<Service*> channels = this->_payload->getServices();

    for(std::vector<Service*>::iterator it = channels.begin(); it != channels.end(); it++) {
        Service* channel = *it;
        if (channel->getDeviceType() == deviceType) {
            result++;
        }
    }

    return result;
}


Service::DEVICE_TYPE DataBase::getServiceType (short channel) {
    return this->_payload->getServiceByRank(channel)->getDeviceType();
}


std::list<CandidateComponent*> * DataBase::getCandidateSensorsList() {
    std::list<CandidateComponent*> * result = new std::list<CandidateComponent*>();

    CandidateComponent* candidateComponent = (CandidateComponent*) NULL;

    std::vector<Component*>::iterator componentIt = this->_payload->getComponents().begin();
    for (; componentIt != this->_payload->getComponents().end(); componentIt++) {

        bool activeSensor = false;
        for(std::vector<Service*>::iterator serviceIt = (*componentIt)->getServices().begin();
            serviceIt != (*componentIt)->getServices().end();
            serviceIt++) {

            // Check that the service is enabled
            if ((*serviceIt)->getState() == Service::ENABLED) {

                // Check that the subsampling rate matches this activation number
                if ((*serviceIt)->processHeartbeat()) {
                    if (candidateComponent == (CandidateComponent*) NULL) {
                        candidateComponent = new CandidateComponent(*componentIt);
                    }
                    candidateComponent->addService(*serviceIt);
                }
            }
        }

        if (candidateComponent != (CandidateComponent*) NULL) {
            result->push_back(candidateComponent);
            candidateComponent = (CandidateComponent*) NULL;
        }

    }

    return result;
}
