#include <iomanip>
#include <sstream>

#include "ControlMessagePart.hpp"


using namespace misnet;


ControlMessagePart::ControlMessagePart(DATA_FRAME_TYPE data_frame_type,
                                       uint16_t payload_module_id, uint16_t ack_value)
    : _data_frame_type((uint8_t) data_frame_type), _payload_module_id(payload_module_id),
      _acknowledge_value(ack_value) {
    this->_control_part_info = (this->_data_frame_type << 22) + ((payload_module_id & PAYLOAD_MODULE_ID_MASK) << 12)
        + (ack_value & ACKNOWLEDGE_VALUE_MASK);
}

std::string ControlMessagePart::serialize() {
    std::stringstream aStream;
    aStream << std::setfill('0') << std::setw(6) << std::hex << this->_control_part_info;

    return aStream.str();
};
