#ifndef __CONFIGDATAMESSAGEPART_HPP__
#define __CONFIGDATAMESSAGEPART_HPP__

#include <vector>

#include "Context.h"

#include "DataMessagePart.hpp"
class ChannelDescription;


namespace misnet {
    class ConfigDataMessagePart;
}


// This class describes the data part of an IOT configuration message.
// It consists in a sequence of description blocks, one per service.
// A 16-bit MAC is appended after the last service description block.
class misnet::ConfigDataMessagePart : virtual DataMessagePart {
    public:

    private:
        vector<ChannelDescription>  _channelDescriptions;   // Vector of channel descriptions
        uint16_t                    _mic;                   // Message Authentication Code
};

#endif  // __CONFIGDATAMESSAGEPART_HPP__
