#ifndef __COMPONENT_HPP__
#define __COMPONENT_HPP__

#include "Context.h"

  
#include <vector>
#include <sstream>

#include "Service.hpp"


namespace misnet {
    class Component;
}


class misnet::Component {

    public:
        enum COMPONENT_ID {
            HTS221    = 1, 
            LPS22HB   = 2, 
            LSM303A   = 3, 
            LSM6DSL   = 4, 
            BME280    = 5, 
            DS18B20   = 6 
        } ;
        
        Component(COMPONENT_ID id, std::vector<Service*>& services) {
            this->id = id;
            this->services = services;
        }
        
        std::vector<Service*>& getServices() {
            return this->services;
        }
        
        void setServices(std::vector<Service*>& serv) {
            this->services = serv;
        }
        
        COMPONENT_ID getId() {
            return this->id;
        }

        std::string toString() {
            std::ostringstream stringStream;
            stringStream << "Component id : " << this->id << std::endl;

            for(std::vector<Service*>::iterator it = services.begin(); it != services.end(); it++) {
                Service * service = *it;
                stringStream << service->toString() << std::endl;
            }

            return stringStream.str();
        }


    private:
        COMPONENT_ID            id;
        std::vector<Service*>   services;
};

#endif // __COMPONENT_HPP__
