#include <iostream>
#include <sstream>
#include <string>

#include "SMTClearMessagePart.hpp"
#include "ControlMessagePart.hpp"


using namespace misnet;


int main(int argc, char** argv) {
    SMTClearMessagePart clearMessagePart(6581);
    std::cout << "Clear message part : <" << clearMessagePart.serialize().c_str() << ">" << std::endl;

    std::string expectedResult = "19b5";

    if (clearMessagePart.serialize().compare(expectedResult) != 0) {
        std::cout << "Erreur sur serialisation de la partie en clair du message." << std::endl;
    }
    else {
        std::cout << "Serialisation de la partie en clair du message OK." << std::endl;
    }

    /*
    CMT = 0000 0000         (CONFIG)
    PMI = 0011 0111 1000    (888)
    RCA = 1101 0000 0101    (3333)

    Control message : 0011 0111 1000 1101 0000 0101 (378D05)
    */

    ControlMessagePart* controlMessagePart = new ControlMessagePart(ControlMessagePart::CONFIG, 888, 3333);
    std::cout << "Control message part : <" << controlMessagePart->serialize().c_str() << ">" << std::endl;

    expectedResult = "378d05";

    if (controlMessagePart->serialize().compare(expectedResult) != 0) {
        std::cout << "Erreur sur serialisation de la partie en clair du message." << std::endl;
    }
    else {
        std::cout << "Serialisation de la partie en clair du message OK." << std::endl;
    }

    delete controlMessagePart;

    /*
    CMT = 0000 0000         (CONFIG)
    PMI = 0000 0000 0011    (3)
    RCA = 0000 0000 0111    (3333)

    Control message : 0000 0000 0011 0000 0000 0111 (003007)
    */

    controlMessagePart = new ControlMessagePart(ControlMessagePart::CONFIG, 3, 7);
    std::cout << "Control message part : <" << controlMessagePart->serialize().c_str() << ">" << std::endl;

    expectedResult = "003007";

    if (controlMessagePart->serialize().compare(expectedResult) != 0) {
        std::cout << "Erreur sur serialisation de la partie en clair du message." << std::endl;
    }
    else {
        std::cout << "Serialisation de la partie en clair du message OK." << std::endl;
    }

    delete controlMessagePart;

    /*
    CMT = 0000 0001         (IOT)
    PMI = 0000 0000 0011    (3)
    RCA = 0000 0000 0111    (3333)

    Control message : 0100 0000 0011 0000 0000 0111 (403007)
    */

    controlMessagePart = new ControlMessagePart(ControlMessagePart::IOT, 3, 7);
    std::cout << "Control message part : <" << controlMessagePart->serialize().c_str() << ">" << std::endl;

    expectedResult = "403007";

    if (controlMessagePart->serialize().compare(expectedResult) != 0) {
        std::cout << "Erreur sur serialisation de la partie en clair du message." << std::endl;
    }
    else {
        std::cout << "Serialisation de la partie en clair du message OK." << std::endl;
    }

    return 0;
}
