#include <iostream>
#include <cstdlib>
#include <string>
#include <string.h>

#include "Context.h"

#include "Value.hpp"


using namespace misnet;


typedef struct {
  Value *         value;
  Value *         value_to_substract;
  Value *         delta;
  bool            expected_result;
  bool *          flag_erreur;
} IDGTD_struct;


typedef struct {
  Value *         value;
  const char *   chaine;
  bool *          flag_erreur;
} GVAS_struct;


static void testDifferencesWithDelta() {
  //Value::GENERIC_VALUE gen_val_1 = { .value.uint8_value=220, .type=Value::UINT8_T };
  //Value value_1(gen_val_1), value_to_substract, delta;
  Value value_1, value_to_substract, delta;

  value_1.setUint8Value(220);
  /*
  DEBUG("Valeur de value_1 : %s\n", value_1.toString().c_str());
  DEBUG("Type de value_1 : %d\n", value_1.getType());
  */
  // std::cout << "Valeur de value_1 : " << value_1.toString() << std::endl;
  
    value_to_substract.setUint8Value(218);
    delta.setUint8Value(1);

    if (value_1.isAbsoluteDifferenceValueGreaterThanDelta(value_to_substract, delta) == false) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs uint8 !\n");
    }
    else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs uint8 OK\n");
    }

    delta.setUint8Value(3);

    if (value_1.isAbsoluteDifferenceValueGreaterThanDelta(value_to_substract, delta) == true) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs uint8 !\n");
    }
    else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs uint8 OK\n");
    }

    bool erreur_bool = false;
    bool erreur_char = false;
    bool erreur_uint8 = false;
    bool erreur_int8 = false;
    bool erreur_uint16 = false;
    bool erreur_int16 = false;
    bool erreur_uint32 = false;
    bool erreur_int32 = false;
    bool erreur_float = false;
    bool erreur_double = false;
    bool erreur_time = false;
    bool erreur_triple_double = false;

      Value bool_value, bool_value_to_substract, bool_delta;
      bool_value.setBoolValue(false);
      bool_value_to_substract.setBoolValue(false);
      bool_delta.setBoolValue(true);

      Value char_value, char_value_to_substract, char_delta;
      char_value.setCharValue('r');
      char_value_to_substract.setCharValue('0');
      char_delta.setCharValue('0');

      Value uint8_value, uint8_value_to_substract, uint8_delta;
      uint8_value.setUint8Value(219);
      uint8_value_to_substract.setUint8Value(212);
      uint8_delta.setUint8Value(5);

      Value int8_value, int8_value_to_substract, int8_delta;
      int8_value.setInt8Value(-110);
      int8_value_to_substract.setInt8Value(-112);
      int8_delta.setInt8Value(3);

      Value uint16_value, uint16_value_to_substract, uint16_delta;
      uint16_value.setUint16Value(1016);
      uint16_value_to_substract.setUint16Value(12);
      uint16_delta.setUint16Value(15);

      Value int16_value, int16_value_to_substract, int16_delta;
      int16_value.setInt16Value(1016);
      int16_value_to_substract.setInt16Value(1015);
      int16_delta.setInt16Value(2);

      Value uint32_value, uint32_value_to_substract, uint32_delta;
      uint32_value.setUint32Value(10161016);
      uint32_value_to_substract.setUint32Value(10161116);
      uint32_delta.setUint32Value(100);

      Value int32_value, int32_value_to_substract, int32_delta;
      int32_value.setInt32Value(-10160000);
      int32_value_to_substract.setInt32Value(-10160001);
      int32_delta.setInt32Value(15);

      Value float_value, float_value_to_substract, float_delta;
      float_value.setFloatValue(-1010.876);
      float_value_to_substract.setFloatValue(-1010.77);
      float_delta.setFloatValue(0.2);

      Value double_value, double_value_to_substract, double_delta;
      double_value.setDoubleValue(-1010.876543);
      double_value_to_substract.setDoubleValue(-1010.876);
      double_delta.setDoubleValue(0.00001);

      Value time_value, time_value_to_substract, time_delta;
      time_value.setTimeValue(1010101010);
      time_value_to_substract.setTimeValue(1010101010);
      time_delta.setTimeValue(10);

      Value triple_double_value, triple_double_value_to_substract, triple_double_delta;
      triple_double_value.setTripleDoubleValue(-777.77, -666.66, 555.55);
      triple_double_value_to_substract.setTripleDoubleValue(-777.0, -666.66, 555.55);
      triple_double_delta.setTripleDoubleValue(0.1, 0.001, 0.001);

      IDGTD_struct   tableau[50] = {
        { &bool_value, &bool_value_to_substract, &bool_delta, false, &erreur_bool },
        { &char_value, &char_value_to_substract, &char_delta, true, &erreur_char },
        { &uint8_value, &uint8_value_to_substract, &uint8_delta, true, &erreur_uint8 },
        { &int8_value, &int8_value_to_substract, &int8_delta, false, &erreur_int8 },
        { &uint16_value, &uint16_value_to_substract, &uint16_delta, true, &erreur_uint16 },
        { &int16_value, &int16_value_to_substract, &int16_delta, false, &erreur_int16 },
        { &uint32_value, &uint32_value_to_substract, &uint32_delta, false, &erreur_uint32 },
        { &int32_value, &int32_value_to_substract, &int32_delta, false, &erreur_int32 },
        { &float_value, &float_value_to_substract, &float_delta, false, &erreur_float },
        { &double_value, &double_value_to_substract, &double_delta, true, &erreur_double },
        { &time_value, &time_value_to_substract, &time_delta, false, &erreur_time },
        { &triple_double_value, &triple_double_value_to_substract, &triple_double_delta, false, &erreur_double }
      };

      for (int i = 0; i < 12; i++) {
        //DEBUG("Value[%d]= %s\n", i, tableau[i].value->toString().c_str());
        if (tableau[i].value->isAbsoluteDifferenceValueGreaterThanDelta(*(tableau[i].value_to_substract),
        *(tableau[i].delta)) != tableau[i].expected_result) {
            DEBUG("Expected : %s, obtained : %s\n", tableau[i].expected_result ? "true" : "false",
            tableau[i].value->isAbsoluteDifferenceValueGreaterThanDelta(*(tableau[i].value_to_substract), *(tableau[i].delta)) ? "true" : "false");
          *(tableau[i].flag_erreur) = true;
        }
      }


      if (erreur_bool) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs bool !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs bool OK\n");
      }

      if (erreur_char) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs char !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs char OK\n");
      }

      if (erreur_uint8) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs uint8 !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs uint8 OK\n");
      }

      if (erreur_int8) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs int8 !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs int8 OK\n");
      }

      if (erreur_uint16) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs uint16 !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs uint16 OK\n");
      }

      if (erreur_int16) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs int16 !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs int16 OK\n");
      }

      if (erreur_uint32) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs uint32 !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs uint32 OK\n");
      }

      if (erreur_int32) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs int32 !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs int32 OK\n");
      }

      if (erreur_float) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs float !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs float OK\n");
      }

      if (erreur_double) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs double !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs double OK\n");
      }

      if (erreur_time) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs time !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs time OK\n");
      }

      if (erreur_triple_double) {
        DEBUG("ERREUR sur isAbsoluteDifferenceValueGreaterThanDelta de valeurs triple_double !\n");
      }
      else {
        DEBUG("isAbsoluteDifferenceValueGreaterThanDelta de valeurs triple_double OK\n");
      }
}


static void testGetValueAsString() {
  bool erreur_bool = false;
  bool erreur_char = false;
  bool erreur_uint8 = false;
  bool erreur_int8 = false;
  bool erreur_uint16 = false;
  bool erreur_int16 = false;
  bool erreur_uint32 = false;
  bool erreur_int32 = false;
  bool erreur_float = false;
  bool erreur_double = false;
  bool erreur_time = false;
  bool erreur_triple_double = false;

  Value bool_val_1;
  bool_val_1.setBoolValue(false);

  Value bool_val_2;
  bool_val_2.setBoolValue(true);

  Value char_val_1;
  char_val_1.setCharValue('r');

  Value char_val_2;
  char_val_2.setCharValue('u');

  Value uint8_val_1;
  uint8_val_1.setUint8Value(219);

  Value uint8_val_2;
  uint8_val_2.setUint8Value(100);

  Value int8_val_1;
  int8_val_1.setInt8Value(-110);

  Value int8_val_2;
  int8_val_2.setInt8Value(-7);

  Value uint16_val_1;
  uint16_val_1.setUint16Value(21905);

  Value uint16_val_2;
  uint16_val_2.setUint16Value(10098);

  Value int16_val_1;
  int16_val_1.setInt16Value(-11000);

  Value int16_val_2;
  int16_val_2.setInt16Value(-7654);

  Value uint32_val_1;
  uint32_val_1.setUint32Value(1905765786);

  Value uint32_val_2;
  uint32_val_2.setUint32Value(10098654);

  Value int32_val_1;
  int32_val_1.setInt32Value(-1010000005);

  Value int32_val_2;
  int32_val_2.setInt32Value(-76543210);

  Value float_val_1;
  float_val_1.setFloatValue(-1010.876);

  Value float_val_2;
  float_val_2.setFloatValue(-7.0/5);

  Value double_val_1;
  double_val_1.setDoubleValue(-1010.876543);

  Value double_val_2;
  double_val_2.setDoubleValue(-7.0/3);

  Value time_val_1;
  time_val_1.setTimeValue(1010101010);

  Value triple_double_val_1;
  double_val_1.setTripleDoubleValue(-321.123, 87.654, 12345.6);

  Value triple_double_val_2;
  double_val_2.setTripleDoubleValue(-7.0/3, 63.0/19, 1.0/7);

  GVAS_struct   tableau[50] = {
    { &bool_val_1, "false", &erreur_bool },
    { &bool_val_2, "true", &erreur_bool },
    { &char_val_1, "r", &erreur_char },
    { &char_val_2, "u", &erreur_char },
    { &uint8_val_1, "219", &erreur_uint8 },
    { &uint8_val_2, "100", &erreur_uint8 },
    { &int8_val_1, "-110", &erreur_int8 },
    { &int8_val_2, "-7", &erreur_int8 },
    { &uint16_val_1, "21905", &erreur_uint16 },
    { &uint16_val_2, "10098", &erreur_uint16 },
    { &int16_val_1, "-11000", &erreur_int16 },
    { &int16_val_2, "-7654", &erreur_int16 },
    { &uint32_val_1, "1905765786", &erreur_uint32 },
    { &uint32_val_2, "10098654", &erreur_uint32 },
    { &int32_val_1, "-1010000005", &erreur_int32 },
    { &int32_val_2, "-76543210", &erreur_int32 },
    { &float_val_1, "-1010.876", &erreur_float },
    { &float_val_2, "-1.4", &erreur_float },
    { &double_val_1, "-1010.876543", &erreur_double },
    { &double_val_2, "-2.33333", &erreur_double },
    { &time_val_1, "1010101010", &erreur_time },
    { &triple_double_val_1, "-321.123,87.654,12345.6", &erreur_triple_double },
    { &triple_double_val_2, "-2.33333,3.31579,0.142857", &erreur_triple_double }
  };

  for (int i = 0; i < 21; i++) {
    //DEBUG("Value[%d]= %s\n", i, tableau[i].value->toString().c_str());
    if (strcmp(tableau[i].value->toString().c_str(), tableau[i].chaine) != 0) {
        DEBUG("Expected : %s, obtained : %s\n", tableau[i].chaine, tableau[i].value->toString().c_str());
      *(tableau[i].flag_erreur) = true;
    }
  }


  if (erreur_bool) {
    DEBUG("ERREUR sur toString de valeurs bool !\n");
  }
  else {
    DEBUG("toString de valeurs bool OK\n");
  }

  if (erreur_char) {
    DEBUG("ERREUR sur toString de valeurs char !\n");
  }
  else {
    DEBUG("toString de valeurs char OK\n");
  }

  if (erreur_uint8) {
    DEBUG("ERREUR sur toString de valeurs uint8 !\n");
  }
  else {
    DEBUG("toString de valeurs uint8 OK\n");
  }

  if (erreur_int8) {
    DEBUG("ERREUR sur toString de valeurs int8 !\n");
  }
  else {
    DEBUG("toString de valeurs int8 OK\n");
  }

  if (erreur_uint16) {
    DEBUG("ERREUR sur toString de valeurs uint16 !\n");
  }
  else {
    DEBUG("toString de valeurs uint16 OK\n");
  }

  if (erreur_int16) {
    DEBUG("ERREUR sur toString de valeurs int16 !\n");
  }
  else {
    DEBUG("toString de valeurs int16 OK\n");
  }

  if (erreur_uint32) {
    DEBUG("ERREUR sur toString de valeurs uint32 !\n");
  }
  else {
    DEBUG("toString de valeurs uint32 OK\n");
  }

  if (erreur_int32) {
    DEBUG("ERREUR sur toString de valeurs int32 !\n");
  }
  else {
    DEBUG("toString de valeurs int32 OK\n");
  }

  if (erreur_float) {
    DEBUG("ERREUR sur toString de valeurs float !\n");
  }
  else {
    DEBUG("toString de valeurs float OK\n");
  }

  if (erreur_double) {
    DEBUG("ERREUR sur toString de valeurs double !\n");
  }
  else {
    DEBUG("toString de valeurs double OK\n");
  }

  if (erreur_time) {
    DEBUG("ERREUR sur toString de valeurs time !\n");
  }
  else {
    DEBUG("toString de valeurs time OK\n");
  }

  if (erreur_triple_double) {
    DEBUG("ERREUR sur toString de valeurs triple_double !\n");
  }
  else {
    DEBUG("toString de valeurs triple_double OK\n");
  }
}


static void testSetGetValues() {
    Value value;
    double* triple_double_value_check;
    bool erreur_bool = false;
    bool erreur_char = false;
    bool erreur_uint8 = false;
    bool erreur_int8 = false;
    bool erreur_uint16 = false;
    bool erreur_int16 = false;
    bool erreur_uint32 = false;
    bool erreur_int32 = false;
    bool erreur_float = false;
    bool erreur_double = false;
    bool erreur_time = false;
    bool erreur_triple_double = false;

    // Valeurs booléennes
    value.setBoolValue(true);
    if (value.getBoolValue() != true) {
        erreur_bool = true;
    }

    value.setBoolValue(false);
    if (value.getBoolValue() != false) {
        erreur_bool = true;
    }

    if (erreur_bool) {
        DEBUG("ERREUR sur set/get de valeurs booleennes !\n");
    }
    else {
        DEBUG("Set/get de valeurs booleennes OK\n");
    }

    // Valeurs char
    value.setCharValue('r');
    if (value.getCharValue() != 'r') {
        erreur_char = true;
    }

    value.setCharValue(65);
    if (value.getCharValue() != 65) {
        erreur_char = true;
    }

    if (erreur_char) {
        DEBUG("ERREUR sur set/get de valeurs char !\n");
    }
    else {
        DEBUG("Set/get de valeurs char OK\n");
    }

    // Valeurs uint8
    value.setUint8Value(67);
    if (value.getUint8Value() != 67) {
        erreur_uint8 = true;
    }

    value.setUint8Value(0);
    if (value.getUint8Value() != 0) {
        erreur_uint8 = true;
    }

    if (erreur_uint8) {
        DEBUG("ERREUR sur set/get de valeurs uint8 !\n");
    }
    else {
        DEBUG("Set/get de valeurs char uint8 OK\n");
    }

    // Valeurs int8
    value.setInt8Value(-67);
    if (value.getInt8Value() != -67) {
        erreur_int8 = true;
    }

    value.setInt8Value(35);
    if (value.getInt8Value() != 35) {
        erreur_int8 = true;
    }

    if (erreur_int8) {
        DEBUG("ERREUR sur set/get de valeurs int8 !\n");
    }
    else {
        DEBUG("Set/get de valeurs char int8\n");
    }

    // Valeurs uint16
    value.setUint16Value(62075);
    if (value.getUint16Value() != 62075) {
        erreur_uint16 = true;
    }

    value.setUint16Value(133);
    if (value.getUint16Value() != 133) {
        erreur_uint16 = true;
    }

    if (erreur_uint16) {
        DEBUG("ERREUR sur set/get de valeurs uint16 !\n");
    }
    else {
        DEBUG("Set/get de valeurs char uint16 OK\n");
    }

    // Valeurs int16
    value.setInt16Value(-6376);
    if (value.getInt16Value() != -6376) {
        erreur_int16 = true;
    }

    value.setInt16Value(3500);
    if (value.getInt16Value() != 3500) {
        erreur_int16 = true;
    }

    if (erreur_int16) {
        DEBUG("ERREUR sur set/get de valeurs int16 !\n");
    }
    else {
        DEBUG("Set/get de valeurs int16 OK\n");
    }

    // Valeurs uint32
    value.setUint32Value(207576544);
    if (value.getUint32Value() != 207576544) {
        erreur_uint32 = true;
    }

    value.setUint32Value(3345678901);
    if (value.getUint32Value() != 3345678901) {
        erreur_uint32 = true;
    }

    if (erreur_uint32) {
        DEBUG("ERREUR sur set/get de valeurs uint32 !\n");
    }
    else {
        DEBUG("Set/get de valeurs char uint32 OK\n");
    }

    // Valeurs int32
    value.setInt32Value(-620757654);
    if (value.getInt32Value() != -620757654) {
        erreur_int32 = true;
    }

    value.setInt32Value(1207576544);
    if (value.getInt32Value() != 1207576544) {
        erreur_int32 = true;
    }

    if (erreur_int32) {
        DEBUG("ERREUR sur set/get de valeurs int32 !\n");
    }
    else {
        DEBUG("Set/get de valeurs int32 OK\n");
    }

    // Valeurs float
    value.setFloatValue(-620.7);
    if ((value.getFloatValue() + 620.7) > 0.0001) {
        erreur_float = true;
    }

    value.setFloatValue(12075765.1);
    if ((value.getFloatValue() - 12075765.1) > 0.0001) {
        erreur_float = true;
    }

    if (erreur_float) {
        DEBUG("ERREUR sur set/get de valeurs float !\n");
    }
    else {
        DEBUG("Set/get de valeurs float OK\n");
    }

    // Valeurs double
    value.setDoubleValue(-6207854.7);
    //DEBUG("Valeur double 1 : %f\n", value._value.value.double_value);
    if ((value.getDoubleValue() + 6207854.7) > 0.000001) {
        erreur_double = true;
    }

    value.setDoubleValue(1207545765.1);
    //DEBUG("Valeur double 2 : %f\n", value._value.value.double_value);
    if ((value.getDoubleValue() - 1207545765.1) > 0.000001) {
        erreur_double = true;
    }

    value.setDoubleValue(-1.0 / 9);
    //DEBUG("Valeur double 3 : %f\n", value._value.value.double_value);
    if ((value.getDoubleValue() + (1.0 / 9)) > 0.000001) {
        erreur_double = true;
    }

    if (erreur_double) {
        DEBUG("ERREUR sur set/get de valeurs double !\n");
    }
    else {
        DEBUG("Set/get de valeurs double OK\n");
    }

    // Valeurs time
    value.setTimeValue(207576544);
    if (value.getTimeValue() != 207576544) {
        erreur_time = true;
    }

    value.setTimeValue(3345678901);
    if (value.getTimeValue() != 3345678901) {
        erreur_time = true;
    }

    if (erreur_time) {
        DEBUG("ERREUR sur set/get de valeurs time !\n");
    }
    else {
        DEBUG("Set/get de valeurs time OK\n");
    }

    // Valeurs triple double
    value.setTripleDoubleValue(-6276.7, -7.0/13, 87.65);
    DEBUG("Valeur double0 : %f\n", value._value.value.triple_double_values[0]);
    DEBUG("Valeur double1 : %f\n", value._value.value.triple_double_values[1]);
    DEBUG("Valeur double2 : %f\n", value._value.value.triple_double_values[2]);
    triple_double_value_check = value.getTripleDoubleValue();
    if ((triple_double_value_check[0] + 6276.7) > 0.000001) {
        erreur_triple_double = true;
    }
    if ((triple_double_value_check[1] + 0.53846) > 0.000001) {
        erreur_triple_double = true;
    }
    if ((triple_double_value_check[2] - 87.65) > 0.000001) {
        erreur_triple_double = true;
    }

    value.setTripleDoubleValue(1207545765.1, 777.777, -111.111);
    DEBUG("Valeur double0 : %f\n", value._value.value.triple_double_values[0]);
    DEBUG("Valeur double1 : %f\n", value._value.value.triple_double_values[1]);
    DEBUG("Valeur double2 : %f\n", value._value.value.triple_double_values[2]);
    triple_double_value_check = value.getTripleDoubleValue();
    if ((triple_double_value_check[0] - 1207545765.1) > 0.000001) {
        erreur_triple_double = true;
    }
    if ((triple_double_value_check[1] - 777.777) > 0.000001) {
        erreur_triple_double = true;
    }
    if ((triple_double_value_check[2] + 111.111) > 0.000001) {
        erreur_triple_double = true;
    }

    if (erreur_triple_double) {
        DEBUG("ERREUR sur set/get de valeurs triple_double !\n");
    }
    else {
        DEBUG("Set/get de valeurs triple_double OK\n");
    }
}


static void testValueComparisons() {
  Value value1, value2;
  value1.setBoolValue(true);
  value2.setBoolValue(false);

  if (value1.compareTo(value2) != 1) {
    DEBUG("ERREUR sur comparaison de valeurs booleennes !\n");
  }
  else {
    DEBUG("Comparaison de valeurs booleennes OK\n");
  }

  value1.setCharValue(65);
  value2.setCharValue(64);

  if (value1.compareTo(value2) != 1) {
    DEBUG("ERREUR sur comparaison de valeurs char !\n");
  }
  else {
    DEBUG("Comparaison de valeurs char OK\n");
  }

  value1.setUint8Value(0);
  value2.setUint8Value(3);

  if (value1.compareTo(value2) != -1) {
    DEBUG("ERREUR sur comparaison de valeurs uint8 !\n");
  }
  else {
    DEBUG("Comparaison de valeurs uint8 OK\n");
  }

  value1.setInt8Value(-117);
  value2.setInt8Value(-116);

  if (value1.compareTo(value2) != -1) {
    DEBUG("ERREUR sur comparaison de valeurs int8 !\n");
  }
  else {
    DEBUG("Comparaison de valeurs int8 OK\n");
  }

  value1.setUint16Value(8764);
  value2.setUint16Value(8760);

  if (value1.compareTo(value2) != 1) {
    DEBUG("ERREUR sur comparaison de valeurs uint16 !\n");
  }
  else {
    DEBUG("Comparaison de valeurs uint16 OK\n");
  }

  value1.setInt16Value(-11740);
  value2.setInt16Value(-11664);

  if (value1.compareTo(value2) != -1) {
    DEBUG("ERREUR sur comparaison de valeurs int16 !\n");
  }
  else {
    DEBUG("Comparaison de valeurs int16 OK\n");
  }

  value1.setUint32Value(87619874);
  value2.setUint32Value(87619874);

  if (value1.compareTo(value2) != 0) {
    DEBUG("ERREUR sur comparaison de valeurs uint32 !\n");
  }
  else {
    DEBUG("Comparaison de valeurs uint32 OK\n");
  }

  value1.setInt32Value(-11740765);
  value2.setInt32Value(-11740766);

  if (value1.compareTo(value2) != 1) {
    DEBUG("ERREUR sur comparaison de valeurs int32 !\n");
  }
  else {
    DEBUG("Comparaison de valeurs int32 OK\n");
  }

  value1.setFloatValue(-1174.75);
  //DEBUG("Valeur float 1 : %f\n", value1._value.value.float_value);
  value2.setFloatValue(-1174.74);
  //DEBUG("Valeur float 2 : %f\n", value2._value.value.float_value);

  if (value1.compareTo(value2) != -1) {
    DEBUG("ERREUR sur comparaison de valeurs float !\n");
  }
  else {
    DEBUG("Comparaison de valeurs float OK\n");
  }

  value1.setDoubleValue(0.6545);
  value2.setDoubleValue(1.8765);

  if (value1.compareTo(value2) != -1) {
    DEBUG("ERREUR sur comparaison de valeurs double !\n");
  }
  else {
    DEBUG("Comparaison de valeurs double OK\n");
  }

  value1.setTimeValue(6545);
  value2.setTimeValue(8765);

  if (value1.compareTo(value2) != -1) {
    DEBUG("ERREUR sur comparaison de valeurs time !\n");
  }
  else {
    DEBUG("Comparaison de valeurs time OK\n");
  }

  value1.setTimeValue(6545);
  value2.setFloatValue(8765.543);

  if (value1.compareTo(value2) != -2) {
    DEBUG("ERREUR sur comparaison de valeurs de types differents !\n");
  }
  else {
    DEBUG("Comparaison de valeurs de types differents OK\n");
  }

  value1.setTripleDoubleValue(0.675, -876.0, 1.23);
  value2.setTripleDoubleValue(0.675, -876.0, 1.23);

  if (value1.compareTo(value2) != 0) {
    DEBUG("ERREUR sur comparaison de valeurs triple_double !\n");
  }
  else {
    DEBUG("Comparaison de valeurs triple_double OK\n");
  }
}


int main(int argc, char** argv) {
  testSetGetValues();
  testValueComparisons();
  testGetValueAsString();
  testDifferencesWithDelta();
  return 0;
}
