#include <iostream>
#include <cstdlib>

#include "Context.h"

#include "Value.hpp"
#include "ExtMemory.hpp"
#include "DataBase.hpp"


using namespace misnet;


static Value*  values[10][4];

static Value value_1_sensor_102, value_2_sensor_102, value_3_sensor_102, value_4_sensor_102, value_5_sensor_102;
static Value value_6_sensor_102, value_7_sensor_102, value_8_sensor_102, value_9_sensor_102, value_10_sensor_102;
static Value value_1_sensor_103, value_2_sensor_103, value_3_sensor_103, value_4_sensor_103, value_5_sensor_103;
static Value value_6_sensor_103, value_7_sensor_103, value_8_sensor_103, value_9_sensor_103, value_10_sensor_103;
static Value value_1_sensor_113, value_2_sensor_113, value_3_sensor_113, value_4_sensor_113, value_5_sensor_113;
static Value value_6_sensor_113, value_7_sensor_113, value_8_sensor_113, value_9_sensor_113, value_10_sensor_113;
static Value value_1_sensor_139, value_2_sensor_139, value_3_sensor_139, value_4_sensor_139, value_5_sensor_139;
static Value value_6_sensor_139, value_7_sensor_139, value_8_sensor_139, value_9_sensor_139, value_10_sensor_139;

static void initValues() {
  values[0][0] = &value_1_sensor_102;
  values[1][0] = &value_2_sensor_102;
  values[2][0] = &value_3_sensor_102;
  values[3][0] = &value_4_sensor_102;
  values[4][0] = &value_5_sensor_102;
  values[5][0] = &value_6_sensor_102;
  values[6][0] = &value_7_sensor_102;
  values[7][0] = &value_8_sensor_102;
  values[8][0] = &value_9_sensor_102;
  values[9][0] = &value_10_sensor_102;
  values[0][1] = &value_1_sensor_103;
  values[1][1] = &value_2_sensor_103;
  values[2][1] = &value_3_sensor_103;
  values[3][1] = &value_4_sensor_103;
  values[4][1] = &value_5_sensor_103;
  values[5][1] = &value_6_sensor_103;
  values[6][1] = &value_7_sensor_103;
  values[7][1] = &value_8_sensor_103;
  values[8][1] = &value_9_sensor_103;
  values[9][1] = &value_10_sensor_103;
  values[0][2] = &value_1_sensor_113;
  values[1][2] = &value_2_sensor_113;
  values[2][2] = &value_3_sensor_113;
  values[3][2] = &value_4_sensor_113;
  values[4][2] = &value_5_sensor_113;
  values[5][2] = &value_6_sensor_113;
  values[6][2] = &value_7_sensor_113;
  values[7][2] = &value_8_sensor_113;
  values[8][2] = &value_9_sensor_113;
  values[9][2] = &value_10_sensor_113;
  values[0][3] = &value_1_sensor_139;
  values[1][3] = &value_2_sensor_139;
  values[2][3] = &value_3_sensor_139;
  values[3][3] = &value_4_sensor_139;
  values[4][3] = &value_5_sensor_139;
  values[5][3] = &value_6_sensor_139;
  values[6][3] = &value_7_sensor_139;
  values[7][3] = &value_8_sensor_139;
  values[8][3] = &value_9_sensor_139;
  values[9][3] = &value_10_sensor_139;

  // Values for sensor 102
  value_1_sensor_102.setInt16Value(10000);  // Should be sent to gateway
  value_2_sensor_102.setInt16Value(10250);  // Should be sent to gateway
  value_3_sensor_102.setInt16Value(10280);  // Should NOT be sent to gateway
  value_4_sensor_102.setInt16Value(10310);  // Should NOT be sent to gateway
  value_5_sensor_102.setInt16Value(10550);  // Should be sent to gateway
  value_6_sensor_102.setInt16Value(10649);  // Should NOT be sent to gateway
  value_7_sensor_102.setInt16Value(10750);  // Should be sent to gateway
  value_8_sensor_102.setInt16Value(10785);  // Should NOT be sent to gateway
  value_9_sensor_102.setInt16Value(10810);  // Should NOT be sent to gateway
  value_10_sensor_102.setInt16Value(10911); // Should be sent to gateway

  // Values for sensor 103
  value_1_sensor_103.setFloatValue(105.5);  // Should NOT be sent to gateway
  value_2_sensor_103.setFloatValue(102.1);  // Should NOT be sent to gateway
  value_3_sensor_103.setFloatValue(108.3);  // Should NOT be sent to gateway
  value_4_sensor_103.setFloatValue(111.0);  // Should be sent to gateway
  value_5_sensor_103.setFloatValue(112.7);  // Should be sent to gateway
  value_6_sensor_103.setFloatValue(111.4);  // Should be sent to gateway
  value_7_sensor_103.setFloatValue(107.1);  // Should NOT be sent to gateway
  value_8_sensor_103.setFloatValue(104.8);  // Should NOT be sent to gateway
  value_9_sensor_103.setFloatValue(105.9);  // Should NOT be sent to gateway
  value_10_sensor_103.setFloatValue(98.7);  // Should be sent to gateway

  // Values for sensor 113
  value_1_sensor_113.setInt8Value(-87);     // Should be sent to gateway
  value_2_sensor_113.setInt8Value(-90);     // Should be sent to gateway
  value_3_sensor_113.setInt8Value(-91);     // Should NOT be sent to gateway
  value_4_sensor_113.setInt8Value(-90);     // Should NOT be sent to gateway
  value_5_sensor_113.setInt8Value(-86);     // Should be sent to gateway
  value_6_sensor_113.setInt8Value(-88);     // Should NOT be sent to gateway
  value_7_sensor_113.setInt8Value(-91);     // Should be sent to gateway
  value_8_sensor_113.setInt8Value(-92);     // Should NOT be sent to gateway
  value_9_sensor_113.setInt8Value(-93);     // Should NOT be sent to gateway
  value_10_sensor_113.setInt8Value(-91);    // Should NOT be sent to gateway

  // Values for sensor 139
  value_1_sensor_139.setDoubleValue(0.654); // Should NOT be sent to gateway
  value_2_sensor_139.setDoubleValue(1.065); // Should be sent to gateway
  value_3_sensor_139.setDoubleValue(0.876); // Should NOT be sent to gateway
  value_4_sensor_139.setDoubleValue(0.2854);    // Should NOT be sent to gateway
  value_5_sensor_139.setDoubleValue(1.01);  // Should be sent to gateway
  value_6_sensor_139.setDoubleValue(0.996); // Should NOT be sent to gateway
  value_7_sensor_139.setDoubleValue(1.002); // Should be sent to gateway
  value_8_sensor_139.setDoubleValue(0.86);  // Should NOT be sent to gateway
  value_9_sensor_139.setDoubleValue(0.77);  // Should NOT be sent to gateway
  value_10_sensor_139.setDoubleValue(1.2675);   // Should be sent to gateway
}


int main(int argc, char** argv) {
  Value value;
  value.setDoubleValue(-1.0 / 81);


  DataBase * database = new DataBase();

  ExtMemory::read(database);

  DEBUG("PAYLOAD\n=======\n%s\n", database->getPayload()->toString().c_str());

  int sensor_index;       // Sensor index; ranges from 0 to 3, since there are 4 active sensors in this configuration
  int sensor_102_value_index;        // Value index; ranges from 0 to 9, since there are 10 values for each active sensor in this test
  int sensor_103_value_index;        // Value index; ranges from 0 to 9, since there are 10 values for each active sensor in this test
  int sensor_113_value_index;        // Value index; ranges from 0 to 9, since there are 10 values for each active sensor in this test
  int sensor_139_value_index;        // Value index; ranges from 0 to 9, since there are 10 values for each active sensor in this test
  int* current_sensor_value_index;

  initValues();

  // Loop to simulate payload heartbeat
  // ----------------------------------
  for (int i = 0, sensor_index = 0, sensor_102_value_index = 0, sensor_103_value_index = 0, sensor_113_value_index = 0, sensor_139_value_index = 0;
       i < 1000000;
       ++i) {

    std::list<CandidateComponent*> * candidateComponents = database->getCandidateSensorsList();

    if (candidateComponents->size() != 0) {
      DEBUG("Iteration #%d\n****************\n", i);

      for (std::list<CandidateComponent*>::iterator candidateComponentIterator = candidateComponents->begin();
       candidateComponentIterator != candidateComponents->end();
       candidateComponentIterator++) {

    DEBUG("Candidate component : %d\n", (*candidateComponentIterator)->getComponent()->getId());
    for (std::list<Service*>::iterator serviceIterator = (*candidateComponentIterator)->getServices().begin();
         serviceIterator != (*candidateComponentIterator)->getServices().end();
         serviceIterator++) {

      DEBUG("\tCandidate service : %d\n", (*serviceIterator)->getMisnetCode());

      switch ((*serviceIterator)->getMisnetCode()) {
      case 102:
        sensor_index = 0;
        current_sensor_value_index = &sensor_102_value_index;
        break;

      case 103:
        sensor_index = 1;
        current_sensor_value_index = &sensor_103_value_index;
        break;

      case 113:
        sensor_index = 2;
        current_sensor_value_index = &sensor_113_value_index;
        break;

      case 139:
        sensor_index = 3;
        current_sensor_value_index = &sensor_139_value_index;
        break;

      default:
        DEBUG("!!! UNEXPECTED MISNET CODE, ENDING TEST !!!");
        return 1;
        break;
      }

      DEBUG("\tSetting value %d of sensor %d, which is %s\n", *current_sensor_value_index, sensor_index,
        values[*current_sensor_value_index][sensor_index]->toString().c_str());
      (*serviceIterator)->setValue(*(values[*current_sensor_value_index][sensor_index]));

      // Increment sensor value index (but modulus 10)
      *current_sensor_value_index = ++(*current_sensor_value_index) % 10;
      DEBUG("\tNew value index for sensor %d : %d\n", sensor_index, *current_sensor_value_index);

      DEBUG("\tCurrent sensor value : %s\n", (*serviceIterator)->getCurrentValueAsString().c_str());
      DEBUG("\tPrevious sensor value : %s\n", (*serviceIterator)->getPreviousValueAsString().c_str());

      if ((*serviceIterator)->valueToBeSentToGateway()) {
        DEBUG("\tValue of service '%s' to be sent to gateway\n", (*serviceIterator)->toString().c_str());
      }
      else {
        DEBUG("\tValue of service '%s' NOT to be sent to gateway\n", (*serviceIterator)->toString().c_str());
      }
    }
      }
    }

    free(candidateComponents);
  }

  return 0;
}
