#ifndef __SMTCLEARMESSAGEPART_HPP__
#define __SMTCLEARMESSAGEPART_HPP__

#include "Context.h"


#include "ClearMessagePart.hpp"


namespace misnet {
    class SMTClearMessagePart;
}


class misnet::SMTClearMessagePart : virtual public ClearMessagePart {
    public:
        SMTClearMessagePart(uint16_t smtId) : ClearMessagePart((uint16_t) ClearMessagePart::SMART_TOOL),
                                                _smtId(smtId & SMART_TOOL_ID_MASK) {
            this->_buffer += smtId & SMART_TOOL_ID_MASK;
        }

    private:
        static const uint16_t   SMART_TOOL_ID_MASK = 0x3FFF;

        uint16_t            _smtId; // Smart Tool identifier
};

#endif  // __SMTCLEARMESSAGEPART_HPP__
