/*
 * lora.h
 *
 *  Created on: 2 sept. 2018
 *      Author: F.Chatain
 */

#ifndef RADIO_H_
#define RADIO_H_

#include "sx1280.h"
#include "mbed.h"
//#include "main.h"


#define     FRAME_SIZE          100
#define     COMMANDLINE_SIZE    100

typedef struct {
    uint8_t         modulation      ;       // LORA / FLRC
    int             spreadingFactor ;       // SFx
    int             bandWidth       ;       // 200 400 ...
    int             codingRate      ;       // 4/5
    unsigned long   frequency       ;       // en Hz
    int             outputPower     ;       // -18 to 13  (ne pas dépasser 5 FEM en service)
    int             size            ;       // message size
} RadioParameter ;


bool    radioSelfTest           (uint16_t *rev) ;
void    radioInitEmitter        (RadioParameter radioParameter );
void    radioInitReceiver       (RadioParameter radioParameter );

void    radioInitRadio          () ;
void    radioSend               (RadioParameter radioParameter, uint8_t  *frame, uint8_t len ) ;
void    radioStartReceive       (RadioParameter radioParameter);
bool    radioHandler            (uint8_t  *frame, uint8_t *len, int8_t *rssi, int8_t *snr);

//void  usbHandler          (USBSerial *cdc) ;

#endif /* RADIO_H_ */
