#ifndef __PAYLOAD_HPP___HPP__
#define __PAYLOAD_HPP___HPP__

#include "Context.h"

#include <vector>
#include <sstream>

#include "Component.hpp"


namespace misnet {
    class Payload;
}

    
class misnet::Payload {

    public:
        // TODO : provide a real list of payload identifiers !
        enum PAYLOAD_ID {
            IOT_PAYLOAD_1           = 1,
            IOT_PAYLOAD_2           = 2,
            IOT_PAYLOAD_3           = 3,
            IOT_PAYLOAD_4           = 4,
            IOT_PAYLOAD_5           = 5,
            IOT_PAYLOAD_6           = 6,
            SMART_TOOL_PAYLOAD_1    = 7,
            SMART_TOOL_PAYLOAD_2    = 8,
            SMART_TOOL_PAYLOAD_3    = 9,
            SMART_TOOL_PAYLOAD_4    = 10
        } ;

        Payload(PAYLOAD_ID id, std::vector<Component*> components, uint16_t base_period);

        std::vector<Component*>& getComponents() {
            return this->_components;
        }

        std::vector<Service*>& getServices() {
            return this->_services;
        }

        Service* getServiceByRank(short channelRank);

        PAYLOAD_ID getId() {
            return this->_id;
        }

        uint16_t getBasePeriod() {
            return this->_basePeriod;
        }

        std::string toString();


    private:
        const PAYLOAD_ID            _id;
        std::vector<Component*>     _components;
        std::vector<Service*>       _services;
        uint16_t                    _basePeriod;
};

#endif // __PAYLOAD_HPP__
