/*
#include <MessageFactory_.h>
#include <MessageFactory.h>
 * MISNet   
 *
 *  Frame:   Fabriquer les messages destinées à être emis
 *
 *  Created on: August 17, 2018       Author: Francis CHATAIN
 *
 */
 
#include "Context.h"

// =====================================  Includes
#ifndef TEST_ENVIRONMENT
#include "mbed.h"
#include "main.h"
#endif

#include "MessageFactory.hpp"

// =====================================  Method of class


using namespace misnet;


MessageFactory::MessageFactory () { }   // constructeur
MessageFactory::~MessageFactory() { }   // delete xxx;


void MessageFactory::buildSensors    () {
#ifndef TEST_ENVIRONMENT
    uint16_t    clearPart           =   0x0000         ;    // 2 Bytes 
    uint16_t    serviceDFT          =   0x00000000     ;    // 2 bits left used 
    uint16_t    servicePMI          =   0x00000000     ;    // 12 bits right used 
    uint16_t    serviceRCA          =   0x00000000     ;    // 12 bits right used 
    uint32_t    servicePart         =   0x00000000     ;    // 4 Bytes   
    uint32_t    serviceMIC          =   0x00000000     ;    // 4 Bytes   
    uint32_t    dataMIC             =   0x00000000     ;    // 4 Bytes   
    uint8_t     *pointer                               ; 
    uint16_t    dataID              =   0x00000000     ;    // 12 bits right used 


    char       frameMISNET     [BUFFER_SIZE_MAX]      ;   // Message 
    memset  ( &frameMISNET  , 0x00, BUFFER_SIZE_MAX );

    // Read DataBase to get information   (here simulated) 
    
    // Formate Clear Part 
    clearPart   =  MODE_ADDR_IOT | ( ID_TERMINAL << 6 ) |  ID_GATEWAY ; 
    printf( "*** MESS ***  CLEAR PART= %8X \r\n ", clearPart);
    
    // CLEAR PART + Indianess correction 
    pointer = (uint8_t*) &clearPart ;       for (int i = 0, j=1 ; i<2 ; i++, j--)  frameMISNET[j]   = pointer[i] ;
  
    // Formate Service Part 
    serviceDFT          =   MODE_DFT_IOT                ;   // Mode IOT 0x40000000
    servicePMI          =   0x0100 & 0x3FF0             ;   // 10 bits    Payload N°16 simulated
    serviceRCA          =   0xBEEF & 0x0FFF             ;   // 3 Bytes   (simulated)
    serviceMIC          =   0xCAFEBEEF  & 0xFFFFFFFF    ;   // 4 Bytes   (simulated)
 
    servicePart =  (uint32_t)( (serviceDFT & 0xC0)    << 24) | 
                      (uint32_t)( (servicePMI & 0x3FF0)  << 16) | 
                      (uint32_t)( (serviceRCA & 0x0FFF)  << 8 ) ;   


    // SERVICE + Indianess correction 
    pointer = (uint8_t*) &servicePart ;  
    for (int i=0, j=2 ; i<3 ; i++, j--)    frameMISNET[2+i] = pointer[j] ;
    pointer = (uint8_t*) &serviceMIC ;             
    for (int i=0, j=3 ; i<4 ; i++, j--)    frameMISNET[5+i] = pointer[j] ;


    // Format data part 
    dataID           =   0x1440 ;   //  Service N°1   Value =  68 
    dataMIC          =   0xBEEFCAFE  & 0xFFFFFFFF    ;   // 4 Bytes   (simulated)

    frameMISNET[9+1]  = pointer[1] ; 
    frameMISNET[9+2]  = pointer[0] ; 
    
    pointer = (uint8_t*) &dataMIC ;             
    for (int i=0, j=3 ; i<4 ; i++, j--)    frameMISNET[11+i] = pointer[j] ;
    
    printf( "*** MESS ***  Message=  "); for (int i = 0 ; i<15 ; i++)  printf ("%02X,", frameMISNET[i] ) ; printf( "\n") ; 
    
    // Store message 
#endif
}

void MessageFactory::buildGoodhealth          () {}   //TODO
void MessageFactory::buildSynchro             () {}   //TODO
void MessageFactory::buildConfiguration       () {}   //TODO
