/*
 *  Controller.hpp
 *
 *  Created on: August 18, 2018
 *      Author: Francis Chatain
 */

#ifndef __CONTROLLER_HPP__
#define __CONTROLLER_HPP__

#include "Context.h"

#ifndef TEST_ENVIRONMENT
#include "mbed.h"
#include "main.h"
#include "MessageFactory.hpp"
#include "Tftlcd.h"
#include "sx1280-hal.h"
#endif

#include "DataBase.hpp"



namespace misnet {
    class Controller;
}

// A deplacer ... 
typedef struct {
    uint8_t         addrType        ;       // Smart Tool/ Gen / Iot/ Asset
    uint16_t        terminalAddr    ;       //
    uint8_t         subnetAddr      ;       //
    uint8_t         raw[2]          ;       // Raw value content Type and Terminal/Network id
    // TODO  Finish coding raw value
} ModeParameter ;



#define     SMART_TOOL_MODE     0x00
#define     GENERIC_MODE        0x40
#define     IOT_MODE            0x80
#define     BROADCAST_MODE      0xC0




class misnet::Controller {

    public:
        // Terminal type
        enum TERMINAL_TYPE {
            SMART_TOOL  = 0,
            GENERIC     = 1,
            IOT         = 2,
            BROADCAST   = 3
        };

        Controller     ();
        virtual ~Controller    ();

#ifndef TEST_ENVIRONMENT
        // @brief Get timer of scheduling mode 
        void getScheduling (uint16_t &TimerPayload,  uint16_t &TimerGoodhealth, uint16_t &TimerSynchro, uint16_t &TimerListening );

        void start                  ();                     // @brief Start the Controller
        void manageSensors          ();                     // @brief 
        void manageGoodhealth       ();                     // @brief 
        void manageSynchro          ();                     // @brief 
        void manageConfiguration    ();                     // @brief 
        void manageListening        ();                     // @brief
#endif


    private:
#ifndef TEST_ENVIRONMENT
        RawSerial * debugSerial  ;       // Serial Instance
     
        // BME280* bme280;   Examples 
        
        void initInterfaces         ();         // @brief Initializes all Interfaces such as I2C, UART and a Debug Serial via USB
        void readMemory             ();         // @brief Read memory to know the list of sensor availables Initializes the Database
     
        void initSensors            ();         // @brief Initializes (builds) all Sensors in their specific modes
        void readSensors            ();         // @brief Request the sensors according to they SensorMode specific parameter

        void initActuators          ();         // @brief Initializes (builds) all Actuator in their specific modes
        void writeActuators         ();         // @brief Request the Actuators according to they ActuatorrMode specific parameters
       
        void sendMessage            ();         // @brief Send Message
#endif

};

#endif  // CONTROLLER_HPP__
