/*
 * bme280_component.hpp
 *
 *  Created on: 17 sept. 2018
 *      Author: hoel
 */

#ifndef BME280_COMPONENT_HPP_
#define BME280_COMPONENT_HPP_

#include <iostream>
#include <cstdlib>
#include "mbed.h"
#include "Context.h"
#include "Service.hpp"
#include "Component.hpp"

using namespace std;
using namespace misnet;

#define DEF_SLAVE_ADDR (0x77 << 1) 	// SDO low
//#define _DEBUG
#ifdef _DEBUG
extern Serial pc2;
#define DEBUG_PRINT(...) pc2.printf(__VA_ARGS__)
#else
#define DEBUG_PRINT(...)
#endif

class bme280_component : public Component{

	private:
    I2C         *i2c_p;
    I2C         &i2c;
    char        address;
    uint16_t    dig_T1=0;
    int16_t     dig_T2=0, dig_T3=0;
    uint16_t    dig_P1=0;
    int16_t     dig_P2=0, dig_P3=0, dig_P4=0, dig_P5=0, dig_P6=0, dig_P7=0, dig_P8=0, dig_P9=0;
    uint16_t    dig_H1=0, dig_H3=0;
    int16_t     dig_H2=0, dig_H4=0, dig_H5=0, dig_H6=0;
    int32_t     t_fine;
	PinName sda = I2C_SDA; // TODO : clean
	PinName scl = I2C_SCL; // TODO : clean
	char slave_adr = DEF_SLAVE_ADDR; // TODO : clean

	public:
	bme280_component(COMPONENT_ID id, std::vector<Service*>& services):
	Component(id, services),
		// TODO : implement peripheral pin arguments
		// BME280_component(PinName sda, PinName scl, char slave_adr,COMPONENT_ID id, std::vector<Service*>& services):
		i2c_p(new I2C(sda, scl)),
		i2c(*i2c_p),
		address(slave_adr),
		t_fine(0)//,
	{
	}
	~bme280_component(){
	    if (NULL != bme280_component::i2c_p)
	        delete  bme280_component::i2c_p;
	}
	bool init(void){

		char cmd[18];

		cmd[0] = 0xf2; // ctrl_hum
		cmd[1] = 0x01; // Humidity oversampling x1
		i2c.write(address, cmd, 2);

		cmd[0] = 0xf4; // ctrl_meas
		cmd[1] = 0x27; // Temperature oversampling x1, Pressure oversampling x1, Normal mode
		i2c.write(address, cmd, 2);

		cmd[0] = 0xf5; // config
		cmd[1] = 0xa0; // Standby 1000ms, Filter off
		i2c.write(address, cmd, 2);

		cmd[0] = 0x88; // read dig_T regs
		i2c.write(address, cmd, 1);
		i2c.read(address, cmd, 6);

		dig_T1 = (cmd[1] << 8) | cmd[0];
		dig_T2 = (cmd[3] << 8) | cmd[2];
		dig_T3 = (cmd[5] << 8) | cmd[4];

		DEBUG_PRINT("dig_T = 0x%x, 0x%x, 0x%x\n", dig_T1, dig_T2, dig_T3);

		cmd[0] = 0x8E; // read dig_P regs
		i2c.write(address, cmd, 1);
		i2c.read(address, cmd, 18);

		dig_P1 = (cmd[ 1] << 8) | cmd[ 0];
		dig_P2 = (cmd[ 3] << 8) | cmd[ 2];
		dig_P3 = (cmd[ 5] << 8) | cmd[ 4];
		dig_P4 = (cmd[ 7] << 8) | cmd[ 6];
		dig_P5 = (cmd[ 9] << 8) | cmd[ 8];
		dig_P6 = (cmd[11] << 8) | cmd[10];
		dig_P7 = (cmd[13] << 8) | cmd[12];
		dig_P8 = (cmd[15] << 8) | cmd[14];
		dig_P9 = (cmd[17] << 8) | cmd[16];

		DEBUG_PRINT("dig_P = 0x%x, 0x%x, 0x%x, 0x%x, 0x%x, 0x%x, 0x%x, 0x%x, 0x%x\n", dig_P1, dig_P2, dig_P3, dig_P4, dig_P5, dig_P6, dig_P7, dig_P8, dig_P9);

		cmd[0] = 0xA1; // read dig_H regs
		i2c.write(address, cmd, 1);
		i2c.read(address, cmd, 1);
		 cmd[1] = 0xE1; // read dig_H regs
		i2c.write(address, &cmd[1], 1);
		i2c.read(address, &cmd[1], 7);

		dig_H1 = cmd[0];
		dig_H2 = (cmd[2] << 8) | cmd[1];
		dig_H3 = cmd[3];
		dig_H4 = (cmd[4] << 4) | (cmd[5] & 0x0f);
		dig_H5 = (cmd[6] << 4) | ((cmd[5]>>4) & 0x0f);
		dig_H6 = cmd[7];

		DEBUG_PRINT("dig_H = 0x%x, 0x%x, 0x%x, 0x%x, 0x%x, 0x%x\n", dig_H1, dig_H2, dig_H3, dig_H4, dig_H5, dig_H6);
		return false;
	}

	/*
	void readValues(void){
		for (std::vector<misnet::Service*>::iterator
				srvIt = this->getServices().begin();
				srvIt != this->getServices().end();
				srvIt++) {
			(*srvIt)->readValue();
		}
	}
	*/

    class bme280_temperature : public Service {

    public:
    	bme280_temperature(
			DEVICE_TYPE type,
			MISNET_CODE misnet_code,
			STATE state,
			ACCESS_TYPE access_type,
			REQUEST_MODE request_mode,
			UP_MODE up_mode,
			ACCESS_PIN access_pins[6],
			uint32_t subsample_rate,
			ACTION action,
			OUTPUT_MODE output_mode,
			string comment,
			bme280_component* parent ):
	        Service(type, misnet_code, state, access_type, request_mode,
	                up_mode, access_pins, subsample_rate, action, output_mode, comment, parent)
    	{
    	}

    	virtual ~bme280_temperature() {}

    	bool readValue(void) {
    	    uint32_t temp_raw;
    	    float tempf;
    	    char cmd[4];

    	    cmd[0] = 0xfa; // temp_msb
    	    parent->i2c.write(parent->address, cmd, 1);
    	    parent->i2c.read(parent->address, &cmd[1], 3);
    	    temp_raw = (cmd[1] << 12) | (cmd[2] << 4) | (cmd[3] >> 4);
    	    int32_t temp;
    	    temp =
    	        (((((temp_raw >> 3) - (parent->dig_T1 << 1))) * parent->dig_T2) >> 11) +
    	        ((((((temp_raw >> 4) - parent->dig_T1) * ((temp_raw >> 4) - parent->dig_T1)) >> 12) * parent->dig_T3) >> 14);
    	    parent->t_fine = temp;
    	    temp = (temp * 5 + 128) >> 8;
    	    tempf = (float)temp;
            this->getValueAddress().setFloatValue(tempf/100.0f);
            this->savePreviousValue();
    	    return false;
    	}

		bool readValue(std::vector<misnet::Service*> servicesWithAsynchronousRead) {
			return this->readValue();
		}
    };

    class bme280_humidity : public Service {

    public:
		bme280_humidity(
			DEVICE_TYPE type,
			MISNET_CODE misnet_code,
			STATE state,
			ACCESS_TYPE access_type,
			REQUEST_MODE request_mode,
			UP_MODE up_mode,
			ACCESS_PIN access_pins[6],
			uint32_t subsample_rate,
			ACTION action,
			OUTPUT_MODE output_mode,
			string comment,
			bme280_component* parent) :
        Service(type, misnet_code, state, access_type, request_mode,
                up_mode, access_pins, subsample_rate, action, output_mode, comment, parent)
		{
		}

		virtual ~bme280_humidity() {}

		bool readValue(void){
			printf("  ID %d,", this->getMisnetCode());
		    uint32_t hum_raw;
		    float humf;
		    char cmd[4];

		    cmd[0] = 0xfd; // hum_msb
		    parent->i2c.write(parent->address, cmd, 1);
		    parent->i2c.read(parent->address, &cmd[1], 2);
		    // TODO return true if reading result is invalid
		    hum_raw = (cmd[1] << 8) | cmd[2];
		    int32_t v_x1;
		    v_x1 = parent->t_fine - 76800;
		    v_x1 =  (((((hum_raw << 14) -(((int32_t)parent->dig_H4) << 20) - (((int32_t)parent->dig_H5) * v_x1)) +
		               ((int32_t)16384)) >> 15) * (((((((v_x1 * (int32_t)parent->dig_H6) >> 10) *
		                                            (((v_x1 * ((int32_t)parent->dig_H3)) >> 11) + 32768)) >> 10) + 2097152) *
		                                            (int32_t)parent->dig_H2 + 8192) >> 14));
		    v_x1 = (v_x1 - (((((v_x1 >> 15) * (v_x1 >> 15)) >> 7) * (int32_t)parent->dig_H1) >> 4));
		    v_x1 = (v_x1 < 0 ? 0 : v_x1);
		    v_x1 = (v_x1 > 419430400 ? 419430400 : v_x1);
		    humf = (float)(v_x1 >> 12);
	        this->getValueAddress().setFloatValue(humf/1024.0f);
	        this->savePreviousValue();
		    return false;
		}

		bool readValue(std::vector<misnet::Service*> servicesWithAsynchronousRead) {
			return this->readValue();
		}
    };

    class bme280_pressure : public Service {

    public:
		bme280_pressure(
			DEVICE_TYPE type,
			MISNET_CODE misnet_code,
			STATE state,
			ACCESS_TYPE access_type,
			REQUEST_MODE request_mode,
			UP_MODE up_mode,
			ACCESS_PIN access_pins[6],
			uint32_t subsample_rate,
			ACTION action,
			OUTPUT_MODE output_mode,
			string comment,
			bme280_component* parent) :
	    Service(type, misnet_code, state, access_type, request_mode,
	            up_mode, access_pins, subsample_rate, action, output_mode, comment, parent)
{
}
		virtual ~bme280_pressure() {}

		bool readValue(void) {
			uint32_t press_raw;
			float pressf;
			char cmd[4];

			cmd[0] = 0xf7; // press_msb
			parent->i2c.write(parent->address, cmd, 1);
			parent->i2c.read(parent->address, &cmd[1], 3);
			// TODO return true if reading result is invalid
			press_raw = (cmd[1] << 12) | (cmd[2] << 4) | (cmd[3] >> 4);
			int32_t var1, var2;
			uint32_t press;
			var1 = (parent->t_fine >> 1) - 64000;
			var2 = (((var1 >> 2) * (var1 >> 2)) >> 11) * parent->dig_P6;
			var2 = var2 + ((var1 * parent->dig_P5) << 1);
			var2 = (var2 >> 2) + (parent->dig_P4 << 16);
			var1 = (((parent->dig_P3 * (((var1 >> 2)*(var1 >> 2)) >> 13)) >> 3) + ((parent->dig_P2 * var1) >> 1)) >> 18;
			var1 = ((32768 + var1) * parent->dig_P1) >> 15;
			if (var1 == 0) {
				return 0;
			}
			press = (((1048576 - press_raw) - (var2 >> 12))) * 3125;
			if(press < 0x80000000) {
				press = (press << 1) / var1;
			} else {
				press = (press / var1) * 2;
			}
			var1 = ((int32_t)parent->dig_P9 * ((int32_t)(((press >> 3) * (press >> 3)) >> 13))) >> 12;
			var2 = (((int32_t)(press >> 2)) * (int32_t)parent->dig_P8) >> 13;
			press = (press + ((var1 + var2 + parent->dig_P7) >> 4));
			pressf = (float)press;
            this->getValueAddress().setFloatValue(pressf/100.0f);
            this->savePreviousValue();
			return false;
		}

		void readValue(std::vector<misnet::Service*> servicesWithAsynchronousRead) {

			// -----------------------------------------------------------------------
			// On suppose que ce capteur de pression nécessite une lecture asynchrone.
			// C'est juste pour l'exemple bien sur.
			// -----------------------------------------------------------------------

			// La première chose consiste à placer le pointeur sur ce service dans le vecteur passé en argument.
			// Ceci permettra au controleur de savoir si le service necessitera une lecture asynchrone,
			// et donc il pourra gerer :
			//		. l'occurrence d'une commande de lecture asynchrone (TerminalAsyncReadCommand)
			//		. le décompte des services encore à lire de manière asynchrone (une fois que le décompte indiquera 0,
			//		  alors le controleur pourra generer un message radio et l'envoyer a la fonction radio).
			servicesWithAsynchronousRead.push_back(this);

			// Il faut ensuite armer un timer avec une durée adaptée à ce capteur.
			// Genre utilisation d'un Timeout auquel est attachée une callback, comme pour le composant DS18B20.
			// La callback doit créer une commande TerminalAsyncReadCommand avec comme argument un pointeur vers le service
			// en question, et l'inserer dans la file des commandes a traiter par le controleur.
			// Cette insertion dans la file est accessible au travers de la methode addCommandInQueue() du singleton
			// permettant d'acceder au controleur (pas encore fait, je fais ça demain ou ce qweek-end).
			// La methode readValue() sans argument, celle qui fait la lecture effective, sera
			// invoquee par la methode execute() de la commande TerminalAsyncReadCommand (c'est dans le code
			// du controleur, tu ne le verras pas).
			// Bien entendu, cette execution est faite de maniere parfaitement generique, sans
			// que le controleur ait connaissance de la classe derivee de Service en question, ce qui
			// permet de pouvoir ajouter de nouveaux composants sans impacter le code generique.
			// C'est cette meme mecanique de file de commandes qui permet de gerer les autres evenements asynchrones
			// comme le heartbeat de la plateforme (niveau batterie, etc.) et les IRQ.
    		int delay = parent->convertTemperature(false, this_device);
    		reader.attach(callback(this, &bme280_component::bme280_pressure::la_callback), delay + 50);
    	}

		void la_callback() {
			// Creer une instance de commande pour traiter la lecture asynchrone.
			Controller::getInstance().addCommandInQueue(new TerminalAsyncReadCommand(this));

			// Tu noteras que la lecture ne doit pas etre effectuee dans la callback, a la difference de
			// ce qui est fait dans la callback du composant DS18B20, car sinon le controleur ne saura pas
			// quelles valeurs ont ete lues ou pas, et ne saura donc pas quand le message peut etre construit
			// et envoye au module radio.
			// Par ailleurs, c'est tres rapide car il y a peu de traitements, et donc on reste tres peu de temps dans la callback.

			// Juste pour info, si ça t'intéresse...
			// -------------------------------------
			// A l'issue du traitement de la callback, le controleur sera reveille, il ira lire la file des commandes
			// (file triee par priorite pour ne pas avoir a gerer d'etats, je t'expliquerai de vive voix si tu veux).
			// Une fois cette commande extraite de la file des commandes, sa methode execute() sera invoquee, qui se traduira
			// par l'appel de la methode readValue() - sans argument donc - du service correspondant au pointeur pâsse en argument
			// du constructeur. Ainsi, la lecture effective sera realisee et la valeur placee dans la database. Et bien sur le pointeur
			// sur le service sera retire du vecteur des services avec lecture asnchrone.
			// Quand il n'y aura plus de pointeur sur service dans le vecteur, cela voudra dire que toutes les valeurs auront ete lues,
			// et donc que le message pourra etre construit et envoye au module radio.
		}

	private:
		Timeout reader;
    };
};

#endif /* BME280_COMPONENT_HPP_ */
