/*
 *  MISNet   
 *
 *  Main   TERMINAL VERSION HALF DUPLEX 
 *
 *  Created on: August 17, 2018    Author: Francis CHATAIN
 *
 */
 
#include "mbed.h"
#include "sx1280-hal.h"
#include "stdio.h"
#include <string>

#include "main.h"
#include "Controller.hpp"

#include "Radio.h"


using namespace std;
using namespace misnet;

//  INSTANCE of CONTROLLER OBJECT 

Controller     controller                       ;       // Core of controller start also 

// ---------------------   A mettre dans la database 
RadioParameter  radioParam          ;       // Serial Read
RadioParameter  radioParamFactory   ;       // Contain Factory
RadioParameter  radioParamEmitter   ;       // Contain Config Emet
RadioParameter  radioParamReceiver  ;       // Contain Config Receiver
ModeParameter   modeParam           ;       // Mission Mode


// A deplacer 
static char *print_double   ( char* str, double v, int decimalDigits=2) ; 


//******************************************************************************
//     Timers
//******************************************************************************
uint16_t TimerPayload, TimerGoodhealth, TimerSynchro, TimerListening = 0L ;
volatile uint32_t listenFlag=0, syncFlag=0, goodHealthFlag=0, payloadFlag=0, irqFlag=0, statPayLoadCounter = 0 ; 
 
LowPowerTicker  wakeUpPayload                   ;       // normal wake up 
void wakeUpPayloadCallback      (void)          ; 

LowPowerTicker  wakeUpGoodhealth                ;       // GoodHealth wake up 
void wakeUpGoodhealthCallback   (void)          ; 

LowPowerTicker  wakeUpSynchro                   ;       // Synchro wake up  (Mode B)
void wakeUpSynchroCallback      (void)          ; 

LowPowerTicker  wakeUpListening                 ;       // Listening wake up (Mode C)
void wakeUpListeningCallback    (void)          ; 

void            setup ()                        ;       // Init Terminal 
void            loop  ()                        ;       // Main Loop 
void            wakeUpIrqTacSwitch ()           ;       // IRQ Tac Switch


// ============================================================================ Main
int main( ) { setup () ; loop () ; }
// ============================================================================


// ============================================================================ Setup
void setup () {

    controller.start    ();         // Start controller 
    
    // -------------------------------------------------- Scheduler  by IRQ or watch dog 
    
    controller.getScheduling          (TimerPayload, TimerGoodhealth, TimerSynchro, TimerListening) ;   // What mode ? 
    
    wakeUpPayload.attach       (&wakeUpPayloadCallback,     (float)TimerPayload )   ;       // Mode A   +  All Mode   
    wakeUpGoodhealth.attach    (&wakeUpGoodhealthCallback,  (float)TimerGoodhealth) ;       // Mode A   +  All Mode 
    
    if ( TimerSynchro !=0) 
        wakeUpSynchro.attach   (&wakeUpSynchroCallback,     (float)TimerSynchro)    ;       // Mode B
        
    if ( TimerSynchro !=0) 
        wakeUpListening.attach (&wakeUpListeningCallback,(float)TimerListening)     ;       // Mode C    
       
        
     // TODO : Associer l'IRQ du TAC switch au handler d'exception    wakeUpIrqTacSwitch
     
    
    // ============================     A mettre dans l'init de la database et de la radio 
    radioParamFactory.modulation            =  PACKET_TYPE_LORA ;
    radioParamFactory.spreadingFactor       =  2                ;
    radioParamFactory.bandWidth             =  1                ;
    radioParamFactory.codingRate            =  0                ;
    radioParamFactory.frequency             =  2400000000UL     ;
    radioParamFactory.outputPower           =  -18              ;

    radioParamReceiver = radioParamFactory ;
    radioParam         = radioParamFactory ;
    radioParamFactory.outputPower           =  0                ;
    radioParamEmitter  = radioParamFactory ;

    modeParam.addrType      = 1     ;
    modeParam.terminalAddr  = 1     ;
    modeParam.subnetAddr    = 0     ;
    modeParam.raw[0]        = GENERIC_MODE ;
    modeParam.raw[1]        = 0x01  ;
    
    uint16_t    FIRMWARE_Radio =    0   ;
    bool        radioStatus             ;       // Status I/F
    radioStatus = radioSelfTest (&FIRMWARE_Radio)   ;   // Radio Test
    
    if (radioStatus) printf ("*** MAIN ***  RADIO OK \r\n"); else printf ("*** MAIN ***  RADIO NOK \r\n") ; 

    radioInitEmitter    ( radioParamEmitter )   ;
    radioInitReceiver   ( radioParamReceiver)   ;
    radioInitRadio      ()                      ;
    //radioStartReceive   (radioParamReceiver)    ;
     
    printf ("*** MAIN ***  SETUP   End   \r\n");
           
}
//==============================================================================


// ============================================================================= LOOP  
void loop () { 

    // A deplacer 
    #define     FRAME_SIZE          100
    uint8_t     frame[FRAME_SIZE]       ;
    char        message[FRAME_SIZE], buffer1[FRAME_SIZE] ;
    uint8_t     _len                    ; 
    int8_t      _rssi                   ;
    int8_t      _snr                    ;  
    
    while(1) { 

        if(listenFlag){     // Listen radio
            printf ("*** MAIN ***  LOOP : wakeUpListeningCallback   \r\n");
            listenFlag=0;  
            controller.manageListening();
        }  
        if(syncFlag){       // Prepare response
            printf ("*** MAIN ***  LOOP : wakeUpSynchroCallback   \r\n");
            syncFlag=0; 
            controller.manageSynchro();
        } 
        if(goodHealthFlag){ // Prepare response
            printf ("*** MAIN ***  LOOP : wakeUpGoodhealthCallback  r\n");
            goodHealthFlag=0; 
            controller.manageGoodhealth(); 
        } 
        if(payloadFlag){    // read Sensors
            printf ("*** MAIN ***  LOOP : wakeUpPayloadCallback cptr=%d\r\n", statPayLoadCounter); 
            payloadFlag=0; 
            //controller.manageSensors(); 
            // To test ciphering and radio send a simple message

            memset  ( &frame   , 0 , FRAME_SIZE ) ;
            memset  ( &message , 0 , FRAME_SIZE ) ;
            // Fab a simple test message 
            frame[0] = 200      ; 
            frame[1] = 55       ;  
            frame[2] = 'T'       ;
            frame[3] = 'E'       ;
            frame[4] = 'S'       ;
            frame[5] = 'T'       ;
            frame[6] = 'S'       ;
            
            int n = sprintf  ( message, "%c%c___%s___",  
                                    0x42, 
                                    55,
                                    print_double (buffer1, statPayLoadCounter)); 
                                    
            memcpy  ( frame    , message   , FRAME_SIZE );                        

            // Send Message 
            _len = strlen (message) ; 
            radioParamEmitter.size  = _len ; 
            radioInitEmitter    (radioParamEmitter)             ;
            radioSend           (radioParamEmitter, frame, _len);
            memset  ( &frame , 0 , FRAME_SIZE ) ;              
        }  
        
        if (radioHandler (frame, &_len, &_rssi, &_snr) ) {
            printf ("*** MAIN ***  LOOP : radioHandler   \r\n"); 
        }
        
        if(irqFlag){        // handle IRQ actions
            printf ("*** MAIN ***  LOOP : wakeUpIrqTacSwitch   \r\n"); 
            irqFlag=0; 
            controller.manageConfiguration(); 
         } 
        // deepsleep ();    // breaks UART 
        //sleep () ; 
        wait(1);
    } 
}
// No action : all event by IRQ 
//==============================================================================




// IRQ du tac switch    TODO 
// ============================================================ IRQ TAC SWITCH
void wakeUpIrqTacSwitch (void) {
    //printf ("*** MAIN ***  wakeUpIrqTacSwitch   \r\n");  
    //app.manageConfiguration         () ;   // IRQ  
    irqFlag=1; 
}


// ============================================================ WATCH DOG PAYLOAD 
void wakeUpPayloadCallback (void) {
    statPayLoadCounter++ ; 
    //printf ("*** MAIN ***  wakeUpPayloadCallback : %d  \r\n", statPayLoadCounter); 
    //app.manageSensors         () ;   // read Sensors   
    payloadFlag=1; 
}

// ============================================================ WATCH DOG GOODHEALTH
void wakeUpGoodhealthCallback (void) {
    //printf ("*** MAIN ***  wakeUpGoodhealthCallback  ==========================   \r\n");
    //app.manageGoodhealth () ;   // Prepare response  
    goodHealthFlag=1; 
}

// ============================================================ WATCH DOG SYNCHRO
void wakeUpSynchroCallback (void) {
    //printf ("*** MAIN ***  wakeUpSynchroCallback   \r\n");
    //app.manageSynchro () ;   // Prepare response  
    syncFlag=1;
}

// ============================================================ WATCH DOG LISTENING
void wakeUpListeningCallback (void) {
    //printf ("*** MAIN ***  wakeUpListeningCallback   \r\n");
    //app.manageListening () ;   // Ecoute radio  
    listenFlag=1;   
}

//*****************************************************************************


// A deplacer 

/* Helper function for printing floats & doubles */
static char *print_double(char* str, double v, int decimalDigits)
{
  int i = 1;
  int intPart, fractPart;
  int len;
  char *ptr;

  /* prepare decimal digits multiplicator */
  for (;decimalDigits!=0; i*=10, decimalDigits--);

  /* calculate integer & fractinal parts */
  intPart = (int)v;
  fractPart = (int)((v-(double)(int)v)*i);

  /* fill in integer part */
  sprintf(str, "%i.", intPart);

  /* prepare fill in of fractional part */
  len = strlen(str);
  ptr = &str[len];

  /* fill in leading fractional zeros */
  for (i/=10;i>1; i/=10, ptr++) {
    if (fractPart >= i) {
      break;
    }
    *ptr = '0';
  }

  /* fill in (rest of) fractional part */
  sprintf(ptr, "%i", fractPart);

  return str;
}


