#include <string>

#include "Value.hpp"

using namespace misnet;


void Value::setValue(Value::GENERIC_VALUE value) {

  this->_value.type = value.type;

  switch (value.type) {
  case Value::BOOLEAN:
    this->_value.value.bool_value = value.value.bool_value;
    break;

  case Value::CHAR:
    this->_value.value.char_value = value.value.char_value;
    break;

  case Value::UINT8_T:
    this->_value.value.uint8_value = value.value.uint8_value;
    break;

  case Value::INT8_T:
    this->_value.value.int8_value = value.value.int8_value;
    break;

  case Value::UINT16_T:
    this->_value.value.uint16_value = value.value.uint16_value;
    break;

  case Value::INT16_T:
    this->_value.value.int16_value = value.value.int16_value;
    break;

  case Value::UINT32_T:
    this->_value.value.uint32_value = value.value.uint32_value;
    break;

  case Value::INT32_T:
    this->_value.value.int32_value = value.value.int32_value;
    break;

  case Value::FLOAT:
    this->_value.value.float_value = value.value.float_value;
    break;

  case Value::DOUBLE:
    this->_value.value.double_value = value.value.double_value;
    break;

  case Value::TIME:
    this->_value.value.time_value = value.value.time_value;
    break;

  case Value::TRIPLE_DOUBLE:
    this->_value.value.triple_double_values[0] = value.value.triple_double_values[0];
    this->_value.value.triple_double_values[1] = value.value.triple_double_values[1];
    this->_value.value.triple_double_values[2] = value.value.triple_double_values[2];
    break;

  default:
    break;
  }
}


int8_t Value::compareTo(Value& otherValue) {
  if (this->_value.type != otherValue._value.type) {
    return -2;
  }

  switch (this->_value.type) {
  case Value::BOOLEAN:
    if (this->_value.value.bool_value == otherValue._value.value.bool_value) {
      return 0;
    }

    else if ((this->_value.value.bool_value == true) && (otherValue._value.value.bool_value == false)) {
      return 1;
    }

    return -1;
    break;

  case Value::CHAR:
    if (this->_value.value.char_value == otherValue._value.value.char_value) {
      return 0;
    }
    else if (this->_value.value.char_value > otherValue._value.value.char_value) {
      return 1;
    }

    return -1;
    break;

  case Value::UINT8_T:
    if (this->_value.value.uint8_value == otherValue._value.value.uint8_value) {
      return 0;
    }
    else if (this->_value.value.uint8_value > otherValue._value.value.uint8_value) {
      return 1;
    }

    return -1;
    break;

  case Value::INT8_T:
    if (this->_value.value.int8_value == otherValue._value.value.int8_value) {
      return 0;
    }
    else if (this->_value.value.int8_value > otherValue._value.value.int8_value) {
      return 1;
    }

    return -1;
    break;

  case Value::UINT16_T:
    if (this->_value.value.uint16_value == otherValue._value.value.uint16_value) {
      return 0;
    }
    else if (this->_value.value.uint16_value > otherValue._value.value.uint16_value) {
      return 1;
    }

    return -1;
    break;

  case Value::INT16_T:
    if (this->_value.value.int16_value == otherValue._value.value.int16_value) {
      return 0;
    }
    else if (this->_value.value.int16_value > otherValue._value.value.int16_value) {
      return 1;
    }

    return -1;
    break;

  case Value::UINT32_T:
    if (this->_value.value.uint32_value == otherValue._value.value.uint32_value) {
      return 0;
    }
    else if (this->_value.value.uint32_value > otherValue._value.value.uint32_value) {
      return 1;
    }

    return -1;
    break;

  case Value::INT32_T:
    if (this->_value.value.int32_value == otherValue._value.value.int32_value) {
      return 0;
    }
    else if (this->_value.value.int32_value > otherValue._value.value.int32_value) {
      return 1;
    }

    return -1;
    break;

  case Value::FLOAT:
    if (this->_value.value.float_value == otherValue._value.value.float_value) {
      return 0;
    }
    else if (this->_value.value.float_value > otherValue._value.value.float_value) {
      return 1;
    }

    return -1;
    break;

  case Value::DOUBLE:
    if (this->_value.value.double_value == otherValue._value.value.double_value) {
      return 0;
    }
    else if (this->_value.value.double_value > otherValue._value.value.double_value) {
      return 1;
    }

    return -1;
    break;

  case Value::TIME:
    if (this->_value.value.time_value == otherValue._value.value.time_value) {
      return 0;
    }
    else if (this->_value.value.time_value > otherValue._value.value.time_value) {
      return 1;
    }

    return -1;
    break;

  case Value::TRIPLE_DOUBLE:
    if ((this->_value.value.triple_double_values[0] == otherValue._value.value.triple_double_values[0])
         && (this->_value.value.triple_double_values[1] == otherValue._value.value.triple_double_values[2])
         && (this->_value.value.triple_double_values[1] == otherValue._value.value.triple_double_values[2])) {
      return 0;
    }
    else if (this->_value.value.triple_double_values[0] > otherValue._value.value.triple_double_values[0]) {
      return 1;
    }

    return -1;
    break;

  default:
    return -2;
    break;
  }
}


std::string Value::toString() {
    /*
  DEBUG("ENTREE\n");
  DEBUG("This = %p\n", this);
  */

  std::ostringstream stringStream;

  switch (this->_value.type) {
  case Value::BOOLEAN:
    stringStream << (this->_value.value.bool_value ? "true" : "false");
    break;

  case Value::CHAR:
    stringStream << this->_value.value.char_value;
    break;

  case Value::UINT8_T:
#if defined(TEST_ENVIRONMENT) && not defined(CPLUSPLUS_99)
    stringStream << std::to_string(this->_value.value.uint8_value);
#else
    stringStream << this->_value.value.uint8_value;
#endif
    break;

  case Value::INT8_T:
#if defined(TEST_ENVIRONMENT) && not defined(CPLUSPLUS_99)
    stringStream << std::to_string(this->_value.value.int8_value);
#else
    stringStream << this->_value.value.int8_value;
#endif
    break;

  case Value::UINT16_T:
    stringStream << this->_value.value.uint16_value;
    break;

  case Value::INT16_T:
    stringStream << this->_value.value.int16_value;
    break;

  case Value::UINT32_T:
    stringStream << this->_value.value.uint32_value;
    break;

  case Value::INT32_T:
    stringStream << this->_value.value.int32_value;
    break;

  case Value::FLOAT:
    stringStream << this->_value.value.float_value;
    break;

  case Value::DOUBLE:
    stringStream << this->_value.value.double_value;
    break;

  case Value::TIME:
    stringStream << this->_value.value.time_value;
    break;

  case Value::TRIPLE_DOUBLE:
    stringStream << this->_value.value.triple_double_values[0] << ","
        << this->_value.value.triple_double_values[1] << ","
        << this->_value.value.triple_double_values[2];
    break;

  case Value::NOT_SET:
  default:
    stringStream << "Value not set !";
    break;
  }

  return stringStream.str();
}


Value Value::substract(Value& otherValue) {
  Value result;

  if (this->_value.type == Value::NOT_SET || otherValue._value.type == Value::NOT_SET) {
    result._value.type = Value::NOT_SET;
    return result;
  }

  if (this->_value.type != otherValue._value.type) {
    result._value.type = Value::NOT_SET;
    return result;
  }

  switch (this->_value.type) {
  case Value::BOOLEAN:
    result._value.type = Value::NOT_SET;
    return result;
    break;

  case Value::CHAR:
    result._value.value.char_value = this->_value.value.char_value - otherValue._value.value.char_value;
    result._value.type = Value::CHAR;
    break;

  case Value::UINT8_T:
    result._value.value.uint8_value = this->_value.value.uint8_value - otherValue._value.value.uint8_value;
    result._value.type = Value::UINT8_T;
    break;

  case Value::INT8_T:
    result._value.value.int8_value = this->_value.value.int8_value - otherValue._value.value.int8_value;
    result._value.type = Value::INT8_T;
    break;

  case Value::UINT16_T:
    result._value.value.uint16_value = this->_value.value.uint16_value - otherValue._value.value.uint16_value;
    result._value.type = Value::UINT16_T;
    break;

  case Value::INT16_T:
    result._value.value.int16_value = this->_value.value.int16_value - otherValue._value.value.int16_value;
    result._value.type = Value::INT16_T;
    break;

  case Value::UINT32_T:
    result._value.value.uint32_value = this->_value.value.uint32_value - otherValue._value.value.uint32_value;
    result._value.type = Value::UINT32_T;
    break;

  case Value::INT32_T:
    result._value.value.int32_value = this->_value.value.int32_value - otherValue._value.value.int32_value;
    result._value.type = Value::INT32_T;
    break;

  case Value::FLOAT:
    result._value.value.float_value = this->_value.value.float_value - otherValue._value.value.float_value;
    result._value.type = Value::FLOAT;
    break;

  case Value::DOUBLE:
    result._value.value.double_value = this->_value.value.double_value - otherValue._value.value.double_value;
    result._value.type = Value::DOUBLE;
    break;

  case Value::TIME:
    result._value.value.time_value = this->_value.value.time_value - otherValue._value.value.time_value;
    result._value.type = Value::TIME;
    break;

  case Value::TRIPLE_DOUBLE:
    result._value.value.triple_double_values[0] = this->_value.value.triple_double_values[0] - otherValue._value.value.triple_double_values[0];
    result._value.value.triple_double_values[1] = this->_value.value.triple_double_values[1] - otherValue._value.value.triple_double_values[1];
    result._value.value.triple_double_values[2] = this->_value.value.triple_double_values[2] - otherValue._value.value.triple_double_values[2];
    result._value.type = Value::TRIPLE_DOUBLE;
    break;

  default:
    result._value.type = Value::NOT_SET;
    break;
  }

  return result;
}


bool Value::isAbsoluteDifferenceValueGreaterThanDelta(Value& valueToSubstract, Value& delta) {
  if (((this->_value.type != valueToSubstract._value.type) || (this->_value.type != valueToSubstract._value.type))
      || (this->_value.type == Value::NOT_SET)) {
    return true;
  }

  int16_t int16_result;
  int32_t int32_result;
  double double_result;

  switch (this->_value.type) {
  case Value::BOOLEAN:
    return false;
    break;

  case Value::CHAR:
    int16_result = (int16_t) this->_value.value.char_value - valueToSubstract._value.value.char_value;
    if (int16_result < 0) {
      int16_result = -int16_result;
    }
    return (int16_result > delta._value.value.char_value);
    break;

  case Value::UINT8_T:
    int16_result = (int16_t) this->_value.value.uint8_value - valueToSubstract._value.value.uint8_value;
    //DEBUG("First value = %d, second value = %d\n", this->_value.value.uint8_value, valueToSubstract._value.value.uint8_value);
    //DEBUG("Difference = %d\n", int16_result);
    if (int16_result < 0) {
      int16_result = -int16_result;
    }
    return (int16_result > delta._value.value.uint8_value);
    break;

  case Value::INT8_T:
    int16_result = this->_value.value.int8_value - valueToSubstract._value.value.int8_value;
    if (int16_result < 0) {
      int16_result = -int16_result;
    }
    return (int16_result > delta._value.value.int8_value);
    break;

  case Value::UINT16_T:
    int32_result = (int32_t) this->_value.value.uint16_value - valueToSubstract._value.value.uint16_value;
    if (int32_result < 0) {
      int32_result = -int32_result;
    }
    return (int32_result > delta._value.value.uint16_value);
    break;

  case Value::INT16_T:
    int32_result = (int32_t) this->_value.value.int16_value - valueToSubstract._value.value.int16_value;
    if (int32_result < 0) {
      int32_result = -int32_result;
    }
    return (int32_result > delta._value.value.int16_value);
    break;

  case Value::UINT32_T:
    double_result = (double) this->_value.value.uint32_value - valueToSubstract._value.value.uint32_value;
    if (double_result < 0) {
      double_result = -double_result;
    }
    return (double_result > delta._value.value.uint32_value);
    break;

  case Value::INT32_T:
    double_result = this->_value.value.int32_value - valueToSubstract._value.value.int32_value;
    if (double_result < 0) {
      double_result = -double_result;
    }
    return (double_result > delta._value.value.int32_value);
    break;

  case Value::FLOAT:
    double_result = this->_value.value.float_value - valueToSubstract._value.value.float_value;
    if (double_result < 0) {
      double_result = -double_result;
    }
    return (double_result > delta._value.value.float_value);
    break;

  case Value::DOUBLE:
    double_result = this->_value.value.double_value - valueToSubstract._value.value.double_value;
    if (double_result < 0) {
      double_result = -double_result;
    }
    return (double_result > delta._value.value.double_value);
    break;

  case Value::TIME:
    double_result = (double) this->_value.value.time_value - valueToSubstract._value.value.time_value;
    if (double_result < 0) {
      double_result = -double_result;
    }
    return (double_result > delta._value.value.time_value);
    break;

  case Value::TRIPLE_DOUBLE:
    double_result = this->_value.value.triple_double_values[0] - valueToSubstract._value.value.triple_double_values[0];
    if (double_result < 0) {
      double_result = -double_result;
    }
    if (double_result > delta._value.value.triple_double_values[0]) {
        return true;
    }

    double_result = this->_value.value.triple_double_values[1] - valueToSubstract._value.value.triple_double_values[1];
    if (double_result < 0) {
      double_result = -double_result;
    }
    if (double_result > delta._value.value.triple_double_values[1]) {
        return true;
    }

    double_result = this->_value.value.triple_double_values[2] - valueToSubstract._value.value.triple_double_values[2];
    if (double_result < 0) {
      double_result = -double_result;
    }
    return (double_result > delta._value.value.triple_double_values[2]);
    break;

  default:
    return true;
    break;
  }
}


bool Value::isDifferentFrom(Value& otherValue) {
  if (this->_value.type != otherValue._value.type) {
    return true;
  }

  switch (this->_value.type) {
  case Value::BOOLEAN:
    return (this->_value.value.bool_value != otherValue._value.value.bool_value);
    break;

  case Value::CHAR:
    return (this->_value.value.char_value != otherValue._value.value.char_value);
    break;

  case Value::UINT8_T:
    return (this->_value.value.uint8_value != otherValue._value.value.uint8_value);
    break;

  case Value::INT8_T:
    return (this->_value.value.int8_value != otherValue._value.value.int8_value);
    break;

  case Value::UINT16_T:
    return (this->_value.value.uint16_value != otherValue._value.value.uint16_value);
    break;

  case Value::INT16_T:
    return (this->_value.value.int16_value != otherValue._value.value.int16_value);
    break;

  case Value::UINT32_T:
    return (this->_value.value.uint32_value != otherValue._value.value.uint32_value);
    break;

  case Value::INT32_T:
    return (this->_value.value.int32_value != otherValue._value.value.int32_value);
    break;

  case Value::FLOAT:
    return (this->_value.value.float_value == otherValue._value.value.float_value);
    break;

  case Value::DOUBLE:
    return (this->_value.value.double_value != otherValue._value.value.double_value);
    break;

  case Value::TIME:
    return (this->_value.value.time_value != otherValue._value.value.time_value);
    break;

  case Value::TRIPLE_DOUBLE:
    return ((this->_value.value.triple_double_values[0] != otherValue._value.value.triple_double_values[0])
        && (this->_value.value.triple_double_values[1] != otherValue._value.value.triple_double_values[1])
        && (this->_value.value.triple_double_values[2] != otherValue._value.value.triple_double_values[2]));
    break;

  default:
    return true;
    break;
  }
}
