/*
 * MISNet   
 *
 *  ExtMemory:   Accès EEPROM 
 *
 *  Created on: August 17, 2018       Author: Francis CHATAIN
 *
 */


// =====================================  Includes
#include <cstdio>
#include "ExtMemory.hpp"
#include "Service.hpp"
#include "Component.hpp"
#include "Payload.hpp"

using namespace misnet;

// =====================================  Methods of class

void ExtMemory::read (DataBase* dataBase) {
    
    printf ( "*** EXTM ***   Read start \n\r");

    // read eeprom  and initialize database
    //(Example)

    uint8_t componentID=0xff;
    int16_t servicesNbr=0, servicesTotal=0;
    int32_t  pos=0;
    ServiceDefinition sd,prev_sd;
    Header hd;
    //EEPROM ep (I2C_SDA, I2C_SCL, EEPROM_ADDR, EEPROM::T24C04);     // FC to compile

    DEBUG( "*** EXTMEM Reading external memory ***\n");

#ifndef TEST_ENVIRONMENT
    dataBase->setRadioParameter ( (uint32_t)2400000000UL, LORA_BW_0400, LORA_SF7, (int8_t)-18, (uint8_t)100, (uint16_t)2000, (uint16_t)2000) ;
#endif

    // ---- read header block
    //ep.read(pos, (void *) &hd, sizeof(hd));
    //if (ep.getError() != 0) error(ep.getErrorMessage());
    pos += sizeof(hd);
    DEBUG("*** [reading header] services:%d mode:0x%02x payloadID:0x%04x ***\n",
            hd.nb_of_services, hd.operating_mode, hd.payload_id);
    servicesTotal = hd.nb_of_services; //dataBase.getNbService()

    // ----  read services blocks
    std::vector<Component*> components = std::vector<Component*>();
    std::vector<Service*> services = std::vector<Service*>();
    Component* component;
    std::string name[6] = {"HTS221","LPS22HB","LSM303D","LSM6DSL","BME280","DS18B20"}; // debug purpose
    
    /*  FC   pour débloquer l'execution 
    while(servicesNbr<servicesTotal){

        while(ep.read(pos, (void *) &sd, sizeof(sd)),(servicesNbr<servicesTotal)){
            pos += sizeof(sd);
            if (ep.getError() != 0) { error(ep.getErrorMessage()); continue;}
            // TODO STATE field is missing in ServiceDefinition
            // TODO access pins
            // Service::ACCESS_PIN access_pins[6] = { 1, 2, 3, 4, 5, 6 };
            Service* service;
//          = new Service((misnet::Service::SERVICE_TYPE) sd.service_type,
//                                          sd.mistnet_code,
//                                          Service::ENABLED,
//                                          (misnet::Service::ACCESS_TYPE) sd.access_type,
//                                          (misnet::Service::REQUEST_MODE) sd.request_mode,
//                                          (misnet::Service::UP_MODE) sd.up_mode,
//                                          access_pins,
//                                          sd.subsample_rate,
//                                          (misnet::Service::ACTION) sd.action,
//                                          (misnet::Service::OUTPUT_MODE) sd.output,
//                                          sd.comment);
            if( componentID == 255 ) componentID = sd.component_id;
            if( (sd.component_id != componentID) || (servicesNbr == servicesTotal-1) ){
                if(servicesNbr == servicesTotal-1) services.push_back(service);
//              component = new Component((misnet::Component::COMPONENT_ID) prev_sd.component_id, services);
                components.push_back(component);
                DEBUG("push component code %d [%s] to vector (%d services)\n",prev_sd.component_id,name[component->getId()-1].c_str(),services.size());
                services.clear();
            }
            services.push_back(service);
            prev_sd = sd;
            componentID = sd.component_id;
            servicesNbr += 1;
        }
        services.clear();
        DEBUG("\n");
    }
    */
    Payload * payload = new Payload((misnet::Payload::PAYLOAD_ID) hd.payload_id, components, hd.payload_base_period);
    dataBase->setPayload(payload);


    /* ******************************************************************************
      In this example, the terminal holds 3 components :
        * the first is a BME280 component, containing 3 sensors :
            * a presence sensor (IPSO code = 102)
            * a temperature sensor (IPSO code = 103)
            * a humidity sensor (IPSO code = 104)
        * the second is a LSM303A component, containing 2 sensors :
            * an accelerometer sensor (IPSO code = 113)
            * a barometer sensor (IPSO code = 115)
        * the third one is a DS18B20 containing an actuator (audio, IPCO code = 139).
      
      The terminal is of type IOT_PAYLOAD_3 (why not ?).
    ****************************************************************************** */


    /* **************************************************************************************
    Pour Hoel et Francis, de la part de Patrick : je me doute bien que les composants BME280,
    LSM303A et DS18B20 ne contiennent pas les devices décrits ici, c'est juste un exemple ;-)
    ************************************************************************************** */

//    Service::ACCESS_PIN access_pins[6] = { 1, 2, 3, 4, 5, 6 };
//
//    // Construction du premier service du premier composant
//    // ----------------------------------------------------
//    Service* service1 = new Service(Service::SENSOR,
//                            102,
//                            Service::ENABLED,
//                            Service::UART_,
//                            Service::IRQ_,
//                            Service::BY_DELTA,
//                            access_pins,
//                            300,
//                            Service::MESSAGE,
//                            Service::IO,
//                            "Premier service du composant BME280 sur cette payload");
//
//    // Construction du deuxieme service du premier composant
//    // -----------------------------------------------------
//    Service* service2 = new Service(Service::SENSOR,
//                            103,
//                            Service::ENABLED,
//                            Service::UART_,
//                            Service::IRQ_,
//                            Service::BY_DELTA,
//                            access_pins,
//                            120,
//                            Service::MESSAGE,
//                            Service::IO,
//                            "Deuxieme service du composant BME280 sur cette payload");
//
//    // Construction du troisieme service du premier composant
//    // ------------------------------------------------------
//    Service* service3 = new Service(Service::SENSOR,
//                            104,
//                            Service::DISABLED,
//                            Service::UART_,
//                            Service::IRQ_,
//                            Service::BY_DELTA,
//                            access_pins,
//                            30,
//                            Service::MESSAGE,
//                            Service::IO,
//                            "Troisieme service du composant BME280 sur cette payload");
//
//    // Construction du premier composant
//    // ---------------------------------
//    std::vector<Service*> services = std::vector<Service*>();
//    services.push_back(service1);
//    services.push_back(service2);
//    services.push_back(service3);
//
//    Component* component1 = new Component(Component::BME280, services);
//
//    // Construction du premier service du deuxieme composant
//    // -----------------------------------------------------
//    Service* service4 = new Service(Service::SENSOR,
//                            113,
//                            Service::ENABLED,
//                            Service::UART_,
//                            Service::IRQ_,
//                            Service::BY_DELTA,
//                            access_pins,
//                            60,
//                            Service::MESSAGE,
//                            Service::IO,
//                            "Premier service du composant LSM303A sur cette payload");
//
//    // Construction du deuxieme service du deuxieme composant
//    // ------------------------------------------------------
//    Service* service5 = new Service(Service::SENSOR,
//                            115,
//                            Service::DISABLED,
//                            Service::UART_,
//                            Service::IRQ_,
//                            Service::BY_DELTA,
//                            access_pins,
//                            80,
//                            Service::MESSAGE,
//                            Service::IO,
//                            "Deuxieme service du composant LSM303A sur cette payload");
//
//    // Construction du deuxieme composant
//    // ----------------------------------
//    services.clear();
//    services.push_back(service4);
//    services.push_back(service5);
//
//    Component* component2 = new Component(Component::LSM303A, services);
//
//
//    // Construction du premier service du troisieme composant
//    // ------------------------------------------------------
//    Service* service6 = new Service(Service::ACTUATOR,
//                            139,
//                            Service::ENABLED,
//                            Service::UART_,

//                            Service::IRQ_,
//                            Service::BY_DELTA,
//                            access_pins,
//                            50,
//                            Service::MESSAGE,
//                            Service::IO,
//                            "Premier service du composant DS18B20 sur cette payload");
//
//    // Construction du troisieme composant
//    // -----------------------------------
//    services.clear();
//    services.push_back(service6);
//
//    Component* component3 = new Component(Component::DS18B20, services);
//
//
//    // Construction de la payload
//    // --------------------------
//    std::vector<Component*> components = std::vector<Component*>();
//    components.push_back(component1);
//    components.push_back(component2);
//    components.push_back(component3);
//
//    Payload * payload = new Payload(Payload::IOT_PAYLOAD_3, components, 10000);
//
//    /* Payload sampling information, based on this example
//       ---------------------------------------------------
//        - Payload base period is 10000, which means 176 microseconds * 10000, i.e. 1.76 seconds
//            - Service 1 : subsample rate is 300, so the service sampling period is 528 seconds
//            - Service 2 : subsample rate is 120, so the service sampling period is 211.2 seconds
//            - Service 3 : subsample rate is 30, so the service sampling period is 52.8 seconds
//            - Service 4 : subsample rate is 60, so the service sampling period is 105.6 seconds
//            - Service 5 : subsample rate is 80, so the service sampling period is 140.8 seconds
//            - Service 6 : subsample rate is 50, so the service sampling period is 35.2 seconds
//        - GCD (Greatest Common Divisor) of its services is 10, so the payload will be awaken
//          every 17.6 seconds.
//    */
//
//    // Enregistrement de la payload dans la database
//    // ---------------------------------------------
//    dataBase->setPayload(payload);

    printf ( "*** EXTM ***   Read done \n\r");

}

/*
void ExtMemory::populate (void) {

    int32_t   pos=0;
    ServiceDefinition sd, sd_r;
    Header hd, hd_r;
    EEPROM ep(I2C_SDA, I2C_SCL, EEPROM_ADDR, EEPROM::T24C04);

    // -----------header----------
    hd.nb_of_services = 5;
    hd.nb_of_sensors = 3;
    hd.operating_mode = 0x09;
    hd.payload_id = 0x1234;
    ep.write((uint32_t) (pos), (void *) &hd, sizeof(hd));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    ep.read((uint32_t) (pos), (void *) &hd_r, sizeof(hd_r));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    pos += sizeof(hd);
    printf("*** [writing header] services:%d mode:0x%02x payloadID:0x%04x***\n",
            hd_r.nb_of_services, hd_r.operating_mode, hd_r.payload_id);


    // ---------services----------
    sd.component_id = Component::DS18B20;
    sd.service_type = Service::SERVICE_TYPE::SENSOR;
    sd.mistnet_code = 0x5f;
    strcpy(sd.comment,"DS1_TEMP");
    ep.write((uint32_t) (pos), (void *) &sd, sizeof(sd));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    ep.read((uint32_t) (pos), (void *) &sd_r, sizeof(sd_r));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    pos += sizeof(sd);
    printf("service1 ID:0x%02x type:0x%02x code:0x%04x\n",
            sd_r.component_id, sd_r.service_type, sd_r.mistnet_code);

    sd.component_id = Component::LSM303D;
    sd.service_type = Service::SERVICE_TYPE::SENSOR;
    sd.mistnet_code = 0x2b;
    strcpy(sd.comment,"LSM_ACCEL");
    ep.write((uint32_t) (pos), (void *) &sd, sizeof(sd));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    ep.read((uint32_t) (pos), (void *) &sd_r, sizeof(sd_r));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    pos += sizeof(sd);
    printf("service2 ID:0x%02x type:0x%02x code:0x%04x\n",
            sd_r.component_id, sd_r.service_type, sd_r.mistnet_code);

    sd.component_id = Component::BME280;
    sd.service_type = Service::SERVICE_TYPE::SENSOR;
    sd.mistnet_code = 0x4a;
    strcpy(sd.comment,"BME_TEMP");
    ep.write((uint32_t) (pos), (void *) &sd, sizeof(sd));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    ep.read((uint32_t) (pos), (void *) &sd_r, sizeof(sd_r));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    pos += sizeof(sd);
    printf("service3 ID:0x%02x type:0x%02x code:0x%04x\n",
            sd_r.component_id, sd_r.service_type, sd_r.mistnet_code);

    sd.component_id = Component::BME280;
    sd.service_type = Service::SERVICE_TYPE::SENSOR;
    sd.mistnet_code = 0x4b;
    strcpy(sd.comment,"BME_HUMI"); 
    ep.write((uint32_t) (pos), (void *) &sd, sizeof(sd));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    ep.read((uint32_t) (pos), (void *) &sd_r, sizeof(sd_r));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    pos += sizeof(sd);
    printf("service4 ID:0x%02x type:0x%02x code:0x%04x\n",
            sd_r.component_id, sd_r.service_type, sd_r.mistnet_code);
    
    sd.component_id = Component::BME280;
    sd.service_type = Service::SERVICE_TYPE::SENSOR;
    sd.mistnet_code = 0x4c;

    strcpy(sd.comment,"BME_BARO");
    ep.write((uint32_t) (pos), (void *) &sd, sizeof(sd));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    ep.read((uint32_t) (pos), (void *) &sd_r, sizeof(sd_r));
    if (ep.getError() != 0) error(ep.getErrorMessage());
    pos += sizeof(sd);
    printf("service5 ID:0x%02x type:0x%02x code:0x%04x\n",
            sd_r.component_id, sd_r.service_type, sd_r.mistnet_code);
}
*/