/*
 * MISNet   
 *
 *  DataBase:   Contient les données du terminal 
 *
 *  Created on: August 17, 2018         Author: Francis CHATAIN
 *
 */

#ifndef __DATABASE_HPP__
#define __DATABASE_HPP__

#include "Context.h"

#ifndef TEST_ENVIRONMENT
#include "mbed.h"
#include "sx1280-hal.h"
#include <string>
#include <list>
#endif

#include "main.h"
#include "Service.hpp"
#include "Component.hpp"
#include "CandidateComponent.hpp"
#include "Payload.hpp"


// =======================================  Define 

#define  MODE_STO   0x0000      //  P2P Smart Tool 
#define  MODE_GEN   0x4000      //  P2P Generic
#define  MODE_IOT   0x8000      //  STAR IoT mode 
#define  MODE_BCA   0xC000      //  STAR Broacast mode 


namespace misnet {
    class DataBase;
}

// =======================================  Class content 
class misnet::DataBase 
{
    enum TERMINAL_TYPE {
        SMART_TOOL = 0,     // Smart Tool
        GENERIC = 1,        // Generic tool
        NORMAL_IOT = 2,     // Normal IOT (the terminal is attached to a gateway)
        BROADCAST_IOT = 3   // Broadcast IOT (the terminal is not attached to a gateway)
    };

 
    public:              
        DataBase     ();
        ~DataBase    ();


        void        init () ;

        TERMINAL_TYPE getTerminalType() {
            //return this->_terminal_type;    // FC to compile
        }

        short         getNbService              (Service::DEVICE_TYPE cdt); // return the number of declared channels for the payload 
        Service::DEVICE_TYPE getServiceType     (short NumService)  ;        // Get Service type 


        void            SetSensorState     (short channel_rank, Service::STATE sensorState) ; // Set Sensor State  (Disable/Enable)  
        Service::STATE  GetSensorState     (short channel_rank) ;                            // Get Sensor State  (Disable/Enable) know if the device shall requested 

        void            SetSensorValue     (uint8_t value) ;             // Set Sensor Value + compute value before storage
        uint8_t         GetSensorMessage   (short channel_rank)     ;             // Get Sensor Message  (False si no change no threahold, response formated)


        short           getNbActuator      () ;
        void            SetActuatorState   () ;
        Service::STATE  GetActuatorState   (short actuator_rank) ;

         
        // =============================================================== Radio Parameter (getter/setter) 
   

#ifndef TEST_ENVIRONMENT
    void getRadioParameter ( uint32_t                   &rfFrequency, 
                        RadioLoRaBandwidths_t           &loraBw,
                        RadioLoRaSpreadingFactors_t     &loraSf ,
                        int8_t                          &txOutputPower,
                        uint8_t                         &bufferSizeMax,
                        int16_t                         &terminal_heartbeat_period,
                        int16_t                         &payload_heartbeat_period);

    void setRadioParameter ( uint32_t                   rfFrequency, 
                        RadioLoRaBandwidths_t           loraBw,
                        RadioLoRaSpreadingFactors_t     loraSf ,
                        int8_t                          txOutputPower,
                        uint8_t                         ufferSizeMax,
                        int16_t                         terminal_heartbeat_period,
                        int16_t                         payload_heartbeat_period);
#endif

    void setPayload(Payload* payload) {
        this->_payload = payload;
    }

    Payload* getPayload() {
        return this->_payload;
    }

    std::list<CandidateComponent*> * getCandidateSensorsList();


    // Private variables /methods
    private:
#ifndef TEST_ENVIRONMENT
        uint32_t                    _rf_frequency        ;   // HzNominal frequency
        RadioLoRaBandwidths_t       _lora_bw             ;   /* 200; 400; 800; 1600 */
        RadioLoRaSpreadingFactors_t _lora_sf             ;   /* SF5; SF6=; SF7; SF8 ; SF9; SF10; SF11 ; SF12 */
        int8_t                      _tx_output_power     ;   /* Output power in dBm [-18..+13] dBm */ 
        uint8_t                     _buffer_size_max     ;   /* Payload size max */
#endif
        uint16_t                    _terminal_heartbeat_period; // Terminal heartbeat period
        uint16_t                    _payload_heartbeat_period;  // Sensors' scan period
        misnet::Payload*            _payload             ;          // Payload definition


    // Protected variable /method 
    protected:

} ; 

#endif  // __DATABASE_HPP__
