/*
 * MISNet   
 *
 *  Controller.cpp 
 *
 *  Created on: August 17, 2018
 *      Author: Francis CHATAIN
 *
 */

/*
#include <sstream>
#include <iostream>
#include <iomanip>
#include <string>
*/

#include "Context.h"

#ifndef TEST_ENVIRONMENT
#include "Tftlcd.h"
#endif


#include "main.h"
#include "Controller.hpp"

#include "DataBase.hpp"
#include "MessageFactory.hpp"
#include "ExtMemory.hpp"


using namespace misnet;


static DataBase         dataBase            ;                   // Database creation 
static MessageFactory   messageFactory      ;                   // Messages Maker   (Sensors, Config, Synchro ...)
static ExtMemory        extMemory           ;                   // Memoire externe

#ifndef TEST_ENVIRONMENT
Tftlcd     tftlcd      ;   // eventuellement a déplacer   (uniquement valable sur les conf nucléo)
#endif



Controller::Controller()  {   // constructeur 
    // Basic  instance
    //this.dataBase    =  DataBase;
    //this.messageFactory     =  Message   ;      // Messages Maker   (Sensors, Config, Synchro ...)
    uint32_t   aValue = 65985;
    std::cout << "0x" << std::hex << aValue << std::endl;

    std::stringstream stream;
    
    stream << "0x" << std::hex << aValue;
    std::string result(stream.str());

    std::cout << result.c_str() << std::endl;

}

Controller::~Controller() { }   // delete xxx;


#ifndef TEST_ENVIRONMENT
void Controller::start (){     // @brief Start the Controller

    initInterfaces      ()          ;   // Primary interface uart, i2c, spi ...
    extMemory.read      (&dataBase) ;   // Read memory to know the list of sensor availables, fill DataBase
    initSensors         ()          ;   // Depend of the list of sensors  launch each
    initActuators       ()          ;   // Depend of the list of actuator launch each
    
    // Read Radio parameter in Database for Lora interface   (example)
    uint32_t                        freq    ; 
    RadioLoRaBandwidths_t           bw      ;
    RadioLoRaSpreadingFactors_t     sf      ;  
    int8_t                          pwr     ; 
    uint8_t                         bsz     ;
    int16_t                         terminal_heartbeat_period;
    int16_t                         payload_heartbeat_period;
    dataBase.getRadioParameter  ( freq, bw, sf, pwr, bsz, terminal_heartbeat_period, payload_heartbeat_period) ; 
     
    //initLora        ( freq, bw, sf, pwr ) ;    // Initialise the radio module 
    
    printf( "*** CTRL ***  start   %ld %d %d %d %d %d \r\n",freq, bw, sf, pwr, bsz, time) ; 

    tftlcd.Update   ( freq, bw, sf, pwr, bsz,  payload_heartbeat_period ) ;     // Show information 
    
    printf( "*** CTRL ***  Start Controller (Send message GoodHealth)\r\n");
    
    messageFactory.buildGoodhealth () ; 
    
    //sendMessageLora () ; 
}

void Controller::initInterfaces    ()  {
    // Depend of the configuration read on DataBase (memory origin)
    
    debugSerial = new RawSerial (USBTX,USBRX, 230400);        // Debug Link 
    tftlcd.Init () ;  
    // I2C, SPI, UART .... 
    
    printf( "*** CTRL ***  End of Init Interface \r\n");
}


void Controller::initSensors(){
    printf( "*** CTRL ***  initSensors \r\n");  
    // depend of the list identified   (example)
    //bme280 = new BME280(i2c_rt);
    // depend of the list identified 
    //bme280->init(config->getBME280_MODE()); 
//    iks01a2.read () ; 
}

void Controller::initActuators(){
    // depend of the list identified   (example)
    //bme280 = new BME280(i2c_rt);
    // depend of the list identified 
    //bme280->init(config->getBME280_MODE());
}

void Controller::manageSensors     () {
    readSensors                     () ; 
    messageFactory.buildSensors     () ; 
    sendMessage                     () ; 
}

void Controller::manageGoodhealth  () {
    readSensors                     () ; 
    messageFactory.buildGoodhealth        () ; 
    //sendMessage                   () ; 
}

void Controller::manageSynchro     () {
    messageFactory.buildSynchro           () ; 
    //sendMessage                   () ; 
}

void Controller::manageConfiguration   () {
    messageFactory.buildConfiguration         () ; 
    //sendMessage                       () ; 
}

void Controller::manageListening () {
}


void Controller::getScheduling (uint16_t &TimerPayload,  uint16_t &TimerGoodhealth, uint16_t &TimerSynchro, uint16_t &TimerListening ) {

    TimerPayload        = 5L     ;   // TODO  Dépend de la lecture de la memoire  (ici simulé)
    TimerGoodhealth     = 60L    ; 
    TimerSynchro        = 0L     ;  
    TimerListening      = 0L     ;                  
}

void Controller::sendMessage       () {
    printf( "*** CTRL ***  sendMessage \r\n");
    //sendMessageLora () ; 
}


void Controller::readSensors       () {
    printf("*** CTRL ***  readSensors \r\n");
    printf("*** CTRL ***  loop on all channels\r\n");
    short nbSensors = dataBase.getNbService(Service::SENSOR);
    printf("*** CTRL *** there are %d sensors in this payload\r\n", nbSensors);
    // depend of the list identified 
    // Each sensor sends an event in the db
    //iks01a2.read () ; 
}

void Controller::writeActuators    () {
    // depend of the list identified 
    // Each sensor send can put a event in the queu
}

#endif
