#ifndef __CONTROLMESSAGEPART_HPP__
#define __CONTROLMESSAGEPART_HPP__

#include <string>

#include "Context.h"

#ifdef TEST_ENVIRONMENT
#include <cstdint>
#else
#include <stdint.h>
#endif


namespace misnet {
    class ControlMessagePart;
}


class misnet::ControlMessagePart {
    public:
        // Data frame type
        enum DATA_FRAME_TYPE {
            CONFIG  = 0,
            IOT     = 1, 
            SYNC    = 2
        };

        ControlMessagePart(DATA_FRAME_TYPE data_frame_type, uint16_t payload_module_id, uint16_t ack_value);

        std::string serialize();        // Returns a string that represents the control data to be sent to gateway

    private:
        static const uint16_t   PAYLOAD_MODULE_ID_MASK = 0x3FFF;
        static const uint16_t   ACKNOWLEDGE_VALUE_MASK = 0xFFF;

        uint32_t    _control_part_info;         // Aggregation of data frame type, payload module id and acknowledge value
        uint8_t     _data_frame_type;           // Data frame type
        uint16_t    _payload_module_id;         // Payload module identification
        uint16_t    _acknowledge_value;         // Acknowledge value
        uint32_t    _message_integrity_code;    // Message Authentication Code
};

#endif  // __CONTROLMESSAGEPART_HPP__
