#ifndef __CLEARMESSAGEPART_HPP__
#define __CLEARMESSAGEPART_HPP__

#include <string>

#include "Context.h"

#ifdef TEST_ENVIRONMENT
#include <cstdint>
#else
#include <stdint.h>
#endif


namespace misnet {
    class ClearMessagePart;
}


class misnet::ClearMessagePart {
    public:
        // Addressing mode
        enum ADDRESSING_MODE {
            SMART_TOOL  = 0,
            GENERIC     = 1, 
            IOT         = 2,
            BROADCAST   = 3
        };

        ClearMessagePart(uint16_t addressingMode) : _buffer(addressingMode << 14) {
        }

        // Returns a string that represents the data to be sent to gateway
        std::string serialize();

    protected:
        uint16_t            _buffer;            // Buffer holding the memory representation of the clear message part
};

#endif  // __CLEARMESSAGEPART_HPP__
