#ifndef __CHANNELDESCRIPTION_HPP__
#define __CHANNELDESCRIPTION_HPP__

#include "Context.h"


#include "DataMessagePart.hpp"


namespace misnet {
    class ChannelDescription;
}


// This class represents a channel description block.
// NB. The term "channel" represents both the channel concept and the index of a service in a payload.
class misnet::ChannelDescription {
    public:

    private:
        uint8_t     _channel;           // Index of the payload channel whose description follows
        uint8_t     _configuration;     // 1 bit for state(enabled/disabled),
                                        // 1 bit for request mode (trigger or frequency),
                                        // 1 bit for trigger mode (by range, by delta or on change)
                                        // and 1 bit RFU
        uint8_t     _type;              // LwM2M/MISNet object code (range starting at 3200)
        uint8_t     _data_type;         // LwM2M value resource data type (range starting at 5000)
};

#endif  // __CHANNELDESCRIPTION_HPP__
