#ifndef __CANDIDATE_COMPONENT_HPP__
#define __CANDIDATE_COMPONENT_HPP__

#include "Context.h"

#include <list>
#include <sstream>
#include <string>


namespace misnet {
    class CandidateComponent;
}


class misnet::CandidateComponent {

    public:
        CandidateComponent(Component* component) : _component(component), _services(std::list<Service*>()) {
        }

        Component* getComponent() {
            return this->_component;
        }

        std::list<Service*> & getServices() {
            return this->_services;
        }

        void addService(Service* service) {
            //DEBUG("\tAdding a pointer to service = %p\n", service);
            //DEBUG("\tCorresponding service = %d\n", service->getMisnetCode());
            this->_services.push_back(service);
        }

    private:
        Component*              _component;
        std::list<Service*>     _services;
};

#endif // __CANDIDATE_COMPONENT_HPP__
