/*
 * generic_component.hpp
 *
 *  Created on: 18 sept. 2018
 *      Author: hoel
 */

#ifndef COMPONENTS_GENERIC_COMPONENT_HPP_
#define COMPONENTS_GENERIC_COMPONENT_HPP_

#include <iostream>
#include <cstdlib>
#include "mbed.h"
#include "Context.h"
#include "Service.hpp"
#include "Component.hpp"

using namespace std;
using namespace misnet;

typedef union{
	float val;
	char bytes[4];
} FLOATUNION_t;
typedef union{
	double val;
	char bytes[8];
} DOUBLEUNION_t;

class generic_component : public Component{

	public:
	generic_component(COMPONENT_ID id, vector<Service*>& services,PinName sda, PinName scl, char slave_adr):

	    i2c_p(new I2C(sda, scl)),
	    i2c(*i2c_p),
	    address(slave_adr)
	{
		i2c.frequency(100000);
	}
	~generic_component();
	void init(void){

	}
	void readValues(void){
		for (std::vector<misnet::Service*>::iterator
				srvIt = this->getServices().begin();
				srvIt != this->getServices().end();
				srvIt++) {
			(*srvIt)->readValue();
		}
	}
	InterruptIn interrupt(D9);

	private:
    I2C         *i2c_p;
    I2C         &i2c;
    char        address;

    class generic_value : public Service{

		public:
    	generic_value(
				DEVICE_TYPE type,
				MISNET_CODE misnet_code,
				STATE state,
				ACCESS_TYPE access_type,
				REQUEST_MODE request_mode,
				UP_MODE up_mode,
				ACCESS_PIN access_pins[6],
				uint32_t subsample_rate,
				ACTION action,
				OUTPUT_MODE output_mode,
				string comment,
				generic_component* parent
				) :
				Service(type, misnet_code, state, access_type, request_mode,
				        up_mode, access_pins, subsample_rate, action, output_mode, comment)
		{
			this->parent = parent;
		}
    	virtual ~generic_value() {}
    	bool readValue(void){

        	FLOATUNION_t flt;
        	char bfr[8];

        	bfr[0] = this->getMisnetCode(); 	// service code
        	// TODO handle async calls
        	//switch(this.CALL_TYPE){
        	//	case SYNC:  bfr[1] = 0x01; break;
        	//	case ASYNC: bfr[1] = 0x02; break;
    		//}
        	bfr[1] = 0x01;
            i2c.write(address, bfr, 2, false);
//        	switch(this.CALL_TYPE){
//        		case SYNC:
//				switch(this->getValueAddress().VALUE_TYPE){
//					case Value::NOT_SET : break;
//					case Value::BOOLEAN : break;
//					case Value::CHAR : break;
//					case Value::UINT8_T : break;
//					case Value::INT8_T : break;
//					case Value::UINT16_T : break;
//					case Value::INT16_T : break;
//					case Value::UINT32_T : break;
//					case Value::INT32_T : break;
//					case Value::FLOAT : i2c.read(address, &flt.bytes[0], 4); this->getValueAddress().setFloatValue(flt.val); break; // 32 bits
//					case Value::DOUBLE : break; // 64 bits
//					case Value::TIME : break; // unix time
//				}
//            	break;
//        		case ASYNC: break;
//    		}
            i2c.read(address, &flt.bytes[0], 4);
            this->getValueAddress().setFloatValue(flt.val);
            this->savePreviousValue();
            DEBUG("received from I2C : %3f - 0x%02x 0x%02x 0x%02x 0x%02x\n",flt.val, flt.bytes[0],flt.bytes[1],flt.bytes[2],flt.bytes[3]);
            return false;
        }
        bool setIrqParams(Service* service, Value threshold, Value up, Value down ){

        	char bfr[16];
        	misnet::Value val;
        	FLOATUNION_t flt;

        	bfr[0] = service->getMisnetCode(); 	// service code
        	bfr[1] = 0x02; 						// threshold cmd
        	i2c.write(address, bfr, 2, false);
        	flt.val = threshold.getFloatValue();
        	i2c.write(address, flt.bytes, 4, false);
            bfr[0] = 0x03; 						// value up cmd
            i2c.write(address, bfr, 1, false);
            i2c.write(address, flt.bytes, 4, false);
            bfr[0] = 0x04; 						// value down cmd
            i2c.write(address, bfr, 1, false);
            i2c.write(address, flt.bytes, 4, true);
            //i2c.read(address, bfr[0], 1); 	// ack
            //if (bfr[0] = 0x11) return 0
            //else return 1;
            return 0;
        }
        void setIrq(Callback <void()> cbck, bool enable){

        	//parent->interrupt.rise(cbck);
        	//if (enable) parent->interrupt.enable_irq();
        	//else parent->interrupt.disable_irq();
        }
		private:
        generic_component *parent;
        Timeout reader;
    };
};

#endif /* COMPONENTS_GENERIC_COMPONENT_HPP_ */
