#include "mbed.h"
#include "ST7567.h"
#include "LM75B.h"
#include "PCAL9555.h"

ST7567 lcd(D11, D13, D12, D9, D10); // mosi, sclk, reset, A0, nCS
LM75B sensor(D14,D15, LM75B::ADDRESS_4);
PCAL9555    gpio_exp(SDA, SCL);
GpioBusOut  leds(gpio_exp, X1_4, X1_5, X1_6, X1_7);
GpioBusIn   joystick(gpio_exp, X0_0, X0_1, X0_2, X0_3, X0_4);
AnalogIn pot(A3);
 
enum led_num {
    OM13082_LD1 = (1 << 0),
    OM13082_LD2 = (1 << 1),
    OM13082_LD3 = (1 << 2),
    OM13082_LD4 = (1 << 3),
};

enum key_num {
    Key_Up     = (1 << X0_4),
    Key_Down   = (1 << X0_0),
    Key_Right  = (1 << X0_3),
    Key_Left   = (1 << X0_2),
    Key_Center = (1 << X0_1),
};


int main()
{

    lcd.set_contrast(0x35);
    lcd.cls();
    
    lcd.locate(0, 1);
    lcd.printf("EMBARCADOS CONTEST NXP");
    
  
    while(true) {   // this is the third thread
        lcd.locate(0, 2 + 8);
        lcd.printf("POT = %.2f\n",(float)pot);
        lcd.printf("Temp = %.1f C\n", sensor.temp());
        
        
        if(pot<0.25f){
            leds.write(0xF);
        }else if((pot>=0.25f) & (pot<0.5f)){
            leds.write(~OM13082_LD1);
        }else if((pot>=0.5f) & (pot<0.75f)){
            leds.write(~(OM13082_LD1|OM13082_LD2));
        }
        else if((pot>=0.75f) & (pot<1.0f)){
            leds.write(~(OM13082_LD1|OM13082_LD2|OM13082_LD3));
        }else{
            leds.write(~(OM13082_LD1|OM13082_LD2|OM13082_LD3|OM13082_LD4));
        }
        
        int keys = joystick.read();
        
        if ((keys & Key_Up) == 0)
            lcd.printf("Key = Up     \n");
        else if ((keys & Key_Down) == 0)
            lcd.printf("Key = Down   \n");
        else if ((keys & Key_Right) == 0)
            lcd.printf("Key = Right  \n");
        else if ((keys & Key_Left) == 0)
            lcd.printf("Key = Left   \n");
        else if ((keys & Key_Center) == 0)
            lcd.printf("Key = Center \n");
        else 
            lcd.printf("Key = No Key \n");
        
        wait(0.5);
    }
}
