#include "mbed.h"
#include "SLCD.h"
#include "MMA8451Q.h"
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)
PinName const SDA = PTE25;
PinName const SCL = PTE24;

SLCD slcd;


int main()
{
 
    PwmOut led_green(LED_GREEN);
    PwmOut led_red(LED_RED);
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    slcd.clear();
    
    while (true) {        
        float y, z;
        int x;
        x = 1000*abs(acc.getAccX());
        y = abs(acc.getAccY());
        z = abs(acc.getAccZ());
         
        slcd.printf("%04d", x); //
        
        led_green = 1.0f - y;
        led_red   = 1.0f - z;

        wait(0.2f);
    }
}