#include "mbed.h"
#include "uLCD_4DGL.h"

#define ORANGE      0xFFA500


uLCD_4DGL uLCD(p28, p27, p30);
DigitalIn pb1(p8); // Bottom Row
DigitalIn pb2(p9);
DigitalIn pb3(p10);
DigitalIn pb4(p11);
DigitalIn pb5(p12); // Middle Row
DigitalIn pb6(p13);
DigitalIn pb7(p14);
DigitalIn pb8(p15);
DigitalIn pb9(p16); // Loop Controls
DigitalIn pb10(p17);
DigitalIn pb11(p18); // Layering
//loop control rgb leds
PwmOut LED_r1(p26);
PwmOut LED_g1(p25);
PwmOut LED_b1(p24);

PwmOut LED_r2(p23);
PwmOut LED_g2(p22);
PwmOut LED_b2(p21);
//layer control rgb led
DigitalOut LED_r3(p5);
DigitalOut LED_g3(p6);
DigitalOut LED_b3(p7);

Serial pc(USBTX, USBRX); // PC Serial port, use pc.

//coordinates for drawing on lcd
//bottom half is 63-127
// 4 columns at 127/5 --> 25, 50, 75, 100
// 2 rows at 64/3 --> 63 + 21, 63 + 42
int row1_y = 127 - 21;
int row2_y = 127 - (21*2);
int col1_x = 25;
int col2_x = 50;
int col3_x = 75;
int col4_x = 100;
//run this when layer changes or loop turns on
void displayLCD(int layer, int l1, int l2){
    //uLCD portion
    //16 lines with 18 characters per line
    uLCD.cls();
    uLCD.locate(6,0);
    uLCD.printf("Layer\n");
    //current Layer
    if (layer%3 == 0){
        uLCD.locate(3,1);
        uLCD.color(BLUE);
        uLCD.printf("1\n");
        }
    else if (layer%3 == 1){
        uLCD.locate(8,1);
        uLCD.color(RED);
        uLCD.printf("2\n");
        }
    else{
        uLCD.locate(13,1);
        uLCD.color(GREEN);
        uLCD.printf("3\n");
        }   
    uLCD.color(GREEN);
    uLCD.locate(0,3);
    //loop control circle --> filled = true, unfilled = false
    uLCD.printf("Loop 1      Loop 2\n");
    if (l1%3 == 1) uLCD.filled_circle(24,44,4, ORANGE);
    else if (l1%3 == 2) uLCD.filled_circle(24,44,4, GREEN);
    else if (l1%3 == 0) uLCD.circle(24,44,4, ORANGE);
    if (l2%3 == 1) uLCD.filled_circle(104,44,4,ORANGE);
    else if (l2%3 == 2) uLCD.filled_circle(104,44,4, GREEN);
    else if (l2%3 == 0) uLCD.circle(104,44,4,ORANGE);
    //draw pushbuttons
    uLCD.circle(col1_x, row1_y, 4, RED); //pb 1
    uLCD.circle(col2_x, row1_y, 4, RED); //pb 2
    uLCD.circle(col3_x, row1_y, 4, RED); //pb 3
    uLCD.circle(col4_x, row1_y, 4, RED); //pb 4
    uLCD.circle(col1_x, row2_y, 4, RED); //pb 5
    uLCD.circle(col2_x, row2_y, 4, RED); //pb 6
    uLCD.circle(col3_x, row2_y, 4, RED); //pb 7
    uLCD.circle(col4_x, row2_y, 4, RED); //pb 8
    }
int main() {
    
    //internal pull ups for the pushbuttons
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    pb5.mode(PullUp);
    pb6.mode(PullUp);
    pb7.mode(PullUp);
    pb8.mode(PullUp);
    pb9.mode(PullUp);
    pb10.mode(PullUp);
    pb11.mode(PullUp);

    

    int count = 0; // Layer Count
    int pb1o;
    int pb2o;
    int pb3o;
    int pb4o;
    int pb5o;
    int pb6o;
    int pb7o;
    int pb8o;
    int pb9o;
    int pb10o;
    int pb11o;
    int loop1 = 0;
    int loop2 = 0;
    
    
    //initialize the layer rgbled
    LED_r3 = 0;
    LED_g3 = 0;
    LED_b3 = 1;
    uLCD.baudrate(300000);
    displayLCD(count,loop1,loop2);
    
    while(1)
    {
        

        pb1o = pb1; // Stores previous pushbutton value (defaults to 1 when not pressed)
        pb2o = pb2;
        pb3o = pb3;
        pb4o = pb4;
        pb5o = pb5;
        pb6o = pb6;
        pb7o = pb7;
        pb8o = pb8;
        pb9o = pb9;
        pb10o = pb10;
        pb11o = pb11;
        
        wait(0.01);
        //draw filled circle at pushbutton spot on lcd when pressed, otherwise it's filled black
        if (pb1 ==0)uLCD.filled_circle(col1_x, row1_y, 4, RED); //pb 1
        else uLCD.filled_circle(col1_x,row1_y,3,BLACK);
        
        if (pb2 ==0)uLCD.filled_circle(col2_x, row1_y, 4, RED); //pb 2
        else uLCD.filled_circle(col2_x,row1_y,3,BLACK);
        
        if (pb3 ==0)uLCD.filled_circle(col3_x, row1_y, 4, RED); //pb 3
        else uLCD.filled_circle(col3_x,row1_y,3,BLACK);
        
        if (pb4 ==0)uLCD.filled_circle(col4_x, row1_y, 4, RED); //pb 4
        else uLCD.filled_circle(col4_x,row1_y,3,BLACK);
        
        if (pb5 ==0)uLCD.filled_circle(col1_x, row2_y, 4, RED); //pb 5
        else uLCD.filled_circle(col1_x,row2_y,3,BLACK);
        
        if (pb6 ==0)uLCD.filled_circle(col2_x, row2_y, 4, RED); //pb 6
        else uLCD.filled_circle(col2_x,row2_y,3,BLACK);
        
        if (pb7 ==0)uLCD.filled_circle(col3_x, row2_y, 4, RED); //pb 7
        else uLCD.filled_circle(col3_x,row2_y,3,BLACK);
        
        if (pb8 ==0)uLCD.filled_circle(col4_x, row2_y, 4, RED); //pb 8
        else uLCD.filled_circle(col4_x,row2_y,3,BLACK);
        
        // Pushbuttons - when pressed, send string to serial port
        if(pb1 == 0 && pb1o != pb1)
        {
            pc.printf("1\n");    
        }
        if(pb2 == 0 && pb2o != pb2)
        {
            pc.printf("2\n");      
        }
        if(pb3 == 0 && pb3o != pb3)
        {
            pc.printf("3\n");
        }
        if(pb4 == 0 && pb4o != pb4)
        {
            pc.printf("4\n");
        }
        if(pb5 == 0 && pb5o != pb5)
        {
            pc.printf("5\n");
        }
        if(pb6 == 0 && pb6o != pb6)
        {
            pc.printf("6\n");
        }
        if(pb7 == 0 && pb7o != pb7)
        {
            pc.printf("7\n");
        }
        if(pb8 == 0 && pb8o != pb8)
        {
            pc.printf("8\n");
        }
        if(pb9 == 0 && pb9o != pb9)
        {
            pc.printf("9\n");
            loop1++;
            if(loop1%3 == 1)
            {
                LED_r1.period(0.0005);
                LED_g1.period(0.0005);
                LED_b1.period(0.0005);
        
                LED_r1 = 1;
                LED_g1 = 0.6;
                LED_b1 = 0;
                
            }
            else if(loop1%3 == 2)
            {
                LED_r1 = 0;
                LED_g1 = 1;
                LED_b1 = 0;
            }
            else if(loop1%3 == 0)
            {
                LED_r1 = 0;
                LED_g1 = 0;
                LED_b1 = 0;
            } 
            displayLCD(count,loop1,loop2); 
        }
        if(pb10 == 0 && pb10o != pb10)
        {
            pc.printf("10\n");
            loop2++;
            if(loop2%3 == 1)
            {
                LED_r2.period(0.0005);
                LED_g2.period(0.0005);
                LED_b2.period(0.0005);
        
                LED_r2 = 1;
                LED_g2 = 0.6;
                LED_b2 = 0;
            }
            else if(loop2%3 == 2)
            {
                LED_r2 = 0;
                LED_g2 = 1;
                LED_b2 = 0;
            }
            else if(loop2%3 == 0)
            {
                LED_r2 = 0;
                LED_g2 = 0;
                LED_b2 = 0;
            }  
            displayLCD(count,loop1,loop2);
        }
        if(pb11 == 0 && pb11o != pb11)
        {
            pc.printf("11\n");
            count++;
            if(count%3 == 1)
            {
                LED_r3 = 1;
                LED_g3 = 0;
                LED_b3 = 0;
            }
            else if(count%3 == 2)
            {
                LED_r3 = 0;
                LED_g3 = 1;
                LED_b3 = 0;
            }
            else if(count%3 == 0)
            {
                LED_r3 = 0;
                LED_g3 = 0;
                LED_b3 = 1;
            }
            displayLCD(count,loop1,loop2);
        }
    }
}
