#include "mbed.h"
#include "uLCD_4DGL.h"
uLCD_4DGL uLCD(p28, p27, p29); // create a global lcd object

// black <=> 2
// white <=> 1

class Nav_Switch
{
public:
    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
    int read();
//boolean functions to test each switch
    bool up();
    bool down();
    bool left();
    bool right();
    bool fire();
//automatic read on RHS
    operator int ();
//index to any switch array style
    bool operator[](int index) {
        return _pins[index];
    };
private:
    BusIn _pins;
 
};
Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
    _pins(up, down, left, right, fire)
{
    _pins.mode(PullUp); //needed if pullups not on board or a bare nav switch is used - delete otherwise
    wait(0.001); //delays just a bit for pullups to pull inputs high
}
inline bool Nav_Switch::up()
{
    return !(_pins[0]);
}
inline bool Nav_Switch::down()
{
    return !(_pins[1]);
}
inline bool Nav_Switch::left()
{
    return !(_pins[2]);
}
inline bool Nav_Switch::right()
{
    return !(_pins[3]);
}
inline bool Nav_Switch::fire()
{
    return !(_pins[4]);
}
inline int Nav_Switch::read()
{
    return _pins.read();
}
inline Nav_Switch::operator int ()
{
    return _pins.read();
}
 
Nav_Switch myNav( p14, p11, p12, p10, p13); //pin order on Sparkfun breakout
 
int whosTurn = 1;
int gb[8][8];
int NUM_COLS = 8;
int NUM_ROWS = 8;
 /*var isEmpty = function(r,c) {
    return board[r][c] == 0;
}
var score = function(boardIn) {
    var blackScore = 0;
    var whiteScore = 0;
    for(var r=0; r<8; r++)
    {
        for(var c=0; c<8; c++)
        {
            var current = board[r][c];
            if(current === 1)
            {
                whiteScore++;
            }
            if(current === -1)
            {
                blackScore++;
            }
        }
    }
    var score = {black: blackScore, white: whiteScore};
    return score;
}
var displayScore = function() {
    var currentScore = score(board);
    textSize(20);
    fill(255, 0, 0);
    text(currentScore.black+" - "+currentScore.white,180,390);
}
 */
void initialize_game_board()
{
    //This is a nested loop to make sure every cell is empty
    //Cell Codes: 0 = empty, 1 = white piece, 2 = black piece
    for (int i = 0; i < NUM_ROWS; i++)
    {
        for (int j = 0; j < NUM_COLS; j++)
        gb[i][j] = 0;
    }
    gb[3][3] = 1;//Put down white piece
    gb[4][4] = 1;//Put down white piece
    gb[3][4] = 2;//Put down black piece
    gb[4][3] = 2;//Put down black piece
    
    uLCD.cls();
    uLCD.background_color(0x007f00);
    
    uLCD.rectangle(7,7,120,120,DGREY);
    uLCD.rectangle(8,8,119,119,DGREY);
    //uLCD.filled_rectangle(8,20,120,21,DGREY);
    
    for( int i = 1; i< 9; i++)
    {
        uLCD.filled_rectangle(8, 7 + 14*i,119,8 + 14*i,DGREY);
    }
    for( int j = 1; j<9; j++)
    {
        uLCD.filled_rectangle(7 + 14*j, 8, 8+14*j, 119, DGREY);
    }
}

void drawCursor(int xCoor, int yCoor) //Expecting x ={0,7} and y ={0,7}
{
    uLCD.filled_rectangle(7 + 14*xCoor, 7 + 14*yCoor,8 + 14*xCoor,22 + 14*yCoor,RED);
    uLCD.filled_rectangle(7 + 14*xCoor, 7 + 14*yCoor,22 + 14*xCoor,8 + 14*yCoor,RED);
    uLCD.filled_rectangle(7 + 14*xCoor, 21 + 14*yCoor,22 + 14*xCoor,22 + 14*yCoor,RED);
    uLCD.filled_rectangle(21 + 14*xCoor, 7 + 14*yCoor,22 + 14*xCoor,22 + 14*yCoor,RED);
}
    
void removeCursor(int xCoor,int yCoor)
{
    uLCD.filled_rectangle(7 + 14*xCoor, 7 + 14*yCoor,8 + 14*xCoor,22 + 14*yCoor,DGREY);
    uLCD.filled_rectangle(7 + 14*xCoor, 7 + 14*yCoor,22 + 14*xCoor,8 + 14*yCoor,DGREY);
    uLCD.filled_rectangle(7 + 14*xCoor, 21 + 14*yCoor,22 + 14*xCoor,22 + 14*yCoor,DGREY);
    uLCD.filled_rectangle(21 + 14*xCoor, 7 + 14*yCoor,22 + 14*xCoor,22 + 14*yCoor,DGREY);
}

/*
var copyBoard = function() {
    var boardCopy = [[0,0,0,0,0,0,0,0],
             [0,0,0,0,0,0,0,0],
             [0,0,0,0,0,0,0,0],
             [0,0,0,0,0,0,0,0],
             [0,0,0,0,0,0,0,0],
             [0,0,0,0,0,0,0,0],
             [0,0,0,0,0,0,0,0],
             [0,0,0,0,0,0,0,0]];
    for(var r=0; r<8; r++)
    {
        for(var c=0; c<8; c++)
        {
            boardCopy[r][c] = board[r][c];
        }
    }
    return boardCopy;
}; */
//Removed DrawEmptyBoard function

/*var drawPiece = function(r,c,player) {
    var xPos = 400/8*c+400/16;
    var yPos = 400/8*r+400/16;
    if(player === 0)
    {
        return;
    }
    fill(0, 0, 0);
    if(player===1)
    {
        fill(255, 255, 255);
    }
    ellipse(xPos,yPos,40,40);
}; */

void drawPieces(){
    for (int i = 0; i < NUM_ROWS; i++)
    {
        for (int j = 0; j < NUM_COLS; j++)
        {
            if(gb[i][j] == 1){
                uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 5 , WHITE);
            }
            if(gb[i][j] == 2){
                uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 5 , BLACK);
            }
        }
    }
}

void drawPiece(int i, int j) { //xCoor, yCoor
    if(gb[i][j] == 1){
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 5 , WHITE);
    }
    if(gb[i][j] == 2){
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 5 , BLACK);
    }
}

void flippingPiece(int i, int j) { //xCoor, yCoor, animation
    if(gb[i][j] == 1){ //Gradually changes a piece White
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 1 , 0x4c4c4c);
        wait(0.1);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 1 , 0xb2b2b2);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 3 , 0x4c4c4c);
        wait(0.1);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 1 , 0xffffff);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 3 , 0xb2b2b2);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 5 , 0x4c4c4c);
        wait(0.1);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 3 , 0xffffff);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 5 , 0xb2b2b2);
        wait(0.1);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 5 , 0xffffff);
        wait(0.1);
    }
    if(gb[i][j] == 2){ //Gradually changes a piece Black
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 1 , 0xb2b2b2);
        wait(0.1);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 1 , 0x4c4c4c);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 3 , 0xb2b2b2);
        wait(0.1);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 1 , 0x000000);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 3 , 0x4c4c4c);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 5 , 0xb2b2b2);
        wait(0.1);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 3 , 0x000000);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 5 , 0x4c4c4c);
        wait(0.1);
        uLCD.filled_circle(14 * (i + 1), 14 * (j + 1), 5 , 0x000000);
        wait(0.1);
    }  
}

void Select(int xCoor, int yCoor){ //function should determine what happens when joy stick pressed
    if(whosTurn%2 == 0) ( //Whites Turn
        //Valid Check, see if move is possible
        
        //Place Piece
        drawPiece(xCoor, yCoor);
        //Convert pieces in 2D Array
        int counter; //Count number of converted pieces
        
        
        //Flip pieces on screen
        for( int m = 0; m<counter; m++) {
                
        }
    }      
}

/*var fillBoard = function() {
    for(var r=0; r<8; r++)
    {
        for(var c=0; c<8; c++)
        {
            drawPiece(r,c,board[r][c]);
        }
    }
};
var drawBoard = function() {
    drawEmptyBoard();
    fillBoard();
};  --------------------------------------------WAS NOT USED VVVVV ----------------------------
/*var flipFromInDir = function(r,c,player,rDir,cDir)
{
    //debug("Checking direction rDir: "+rDir+"    cDir: "+cDir+" for player "+player);
    var currentR = r;
    var currentC = c;
    var current = board[currentR][currentC];
    var toBeFlipped = [];
    var withinRBounds = 0<=currentR && currentR<8;
    var withinCBounds = 0<=currentC && currentC<8;
    var oppositePieces = true;
    var samePlayerEncounterred = false;
    while(withinRBounds && withinCBounds && oppositePieces)
    {
        //debug("    oh, sweet! "+currentR+", "+currentC+" looks good!");
        toBeFlipped.push({r:currentR, c:currentC});
        currentR += rDir;
        currentC += cDir;
        withinRBounds = 0<=currentR && currentR<8;
        withinCBounds = 0<=currentC && currentC<8;
        if(withinCBounds && withinRBounds)
        {
            current = board[currentR][currentC];
            oppositePieces = (current===-player);
            //debug("    current at "+currentR+", "+currentC+" is "+current);
            //debug("    oppositePieces at "+currentR+", "+currentC+" is "+oppositePieces);
            if(current===player)
            {
                samePlayerEncounterred = true;
            }
        }
    }
    //debug("    we found "+toBeFlipped.length);
    if(toBeFlipped.length > 1 && samePlayerEncounterred)
    {
        for(var i=1; i<toBeFlipped.length; i++)
        {
            var flipMe = toBeFlipped[i];
            drawPiece(flipMe.r, flipMe.c, player);
            board[flipMe.r][flipMe.c] = player;
        }
    }
};  -------------------------------WAS NOT USED ^^^^--------------------
var flipFromInDir = function(r,c,player,rDir,cDir) {
    var potentialBoard = copyBoard();
    
    var currentR = r+rDir;
    var currentC = c+cDir;
    var withinRBounds = 0<=currentR && currentR<8;
    var withinCBounds = 0<=currentC && currentC<8;
    
    while(withinRBounds && withinCBounds)
    {
        debug("r,c: "+r+", "+c+"   direction: "+rDir+", "+cDir+"   current: "+currentR+", "+currentC);
        var current = board[currentR][currentC];
        if(current === 0)
        {
            return board;
        }
        else if(current === player)
        {
            //board = potentialBoard;
            return potentialBoard;
        }
        else
        {
            potentialBoard[currentR][currentC] = player;
            currentR = currentR+rDir;
            currentC = currentC+cDir;
            withinRBounds = 0<=currentR && currentR<8;
            withinCBounds = 0<=currentC && currentC<8;
        }
    }
    return board;
};
var flipFrom = function(r,c,player) {
    for(var rDir = -1; rDir<2; rDir++)
    {
        for(var cDir = -1; cDir<2; cDir++)
        {
            board = flipFromInDir(r, c, player, rDir, cDir);
        }
    }
};
var placePiece = function(r,c,player) {
    //debug("placing piece for player "+player);
    drawPiece(r,c,player);
    board[r][c] = player;
    flipFrom(r,c,player);
    drawBoard();
};
var move = function(r,c)
{
    placePiece(r,c,whosTurn);
    whosTurn *= -1;
};
var isValidInDir = function(r,c,player,rDir,cDir)
{
    //debug("Checking direction rDir: "+rDir+"    cDir: "+cDir+" for player "+player);
    var currentR = r;
    var currentC = c;
    var current = board[currentR][currentC];
    var toBeFlipped = [];
    var withinRBounds = 0<=currentR && currentR<8;
    var withinCBounds = 0<=currentC && currentC<8;
    var oppositePieces = true;
    var samePlayerEncounterred = false;
    while(withinRBounds && withinCBounds && oppositePieces)
    {
        //debug("    oh, sweet! "+currentR+", "+currentC+" looks good!");
        toBeFlipped.push({r:currentR, c:currentC});
        currentR += rDir;
        currentC += cDir;
        withinRBounds = 0<=currentR && currentR<8;
        withinCBounds = 0<=currentC && currentC<8;
        if(withinCBounds && withinRBounds)
        {
            current = board[currentR][currentC];
            oppositePieces = (current===-player);
            //debug("    current at "+currentR+", "+currentC+" is "+current);
            //debug("    oppositePieces at "+currentR+", "+currentC+" is "+oppositePieces);
            if(current===player)
            {
                samePlayerEncounterred = true;
            }
        }
    }
    //debug("    we found "+toBeFlipped.length);
    if(toBeFlipped.length > 1 && samePlayerEncounterred)
    {
        return true;
    }
    return false;
};
var isValidMove = function(r,c,player) {
    if(!isEmpty(r,c))
    {
        return false;
    }
    for(var rDir = -1; rDir<2; rDir++)
    {
        for(var cDir = -1; cDir<2; cDir++)
        {
            if(isValidInDir(r, c, player, rDir, cDir))
            {
                return true;
            }
        }
    }
    return false;
};
var mouseClicked = function() {
    var r = floor(mouseY*8/400);
    var c = floor(mouseX*8/400);
    if(isValidMove(r,c,whosTurn))
    {
        move(r,c);
    }
    displayScore();
}; 
*/
int main() {
    initialize_game_board();
    int xCoor = 3;
    int yCoor = 4;
    
    
    while(1) {
        //with pullups a button hit is a "0" - "~" inverts data to leds
        //~(myNav & 0x0F); //update leds with nav switch direction inputs
        if(myNav[0] == 0 && xCoor != 0){xCoor --;}
        if(myNav[1] == 0 && xCoor != 7){xCoor ++;}
        if(myNav[2] == 0 && yCoor != 0){xCoor --;}
        if(myNav[3] == 0 && yCoor != 7){xCoor ++;}
        if(myNav.fire()) {Select(xCoor, yCoor);} // Press Down Joystick for Select
        //or use - if(myNav[4]==0) mbedleds = 0x0F; //can index a switch bit like this
        wait(0.02);
    }

}
//initializeBoard();
//drawBoard();
//displayScore();