/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_WEIGHT_SERVICE_H__
#define __BLE_WEIGHT_SERVICE_H__

typedef struct  {
        int32_t integer;
        uint8_t decimal;
    }PACKED WeightType_t;
    
class WEIGHTService {
public:
    const static uint16_t WEIGHT_SERVICE_UUID              = 0xA100;
    const static uint16_t WEIGHT_STATE_CHARACTERISTIC_UUID = 0xA101;
    
//    WEIGHTService(BLEDevice &_ble, float initialValueForWEIGHTCharacteristic) :
    WEIGHTService(BLEDevice &_ble, WeightType_t initialWeight) :
        ble(_ble), weightState(WEIGHT_STATE_CHARACTERISTIC_UUID, &initialWeight)
    {
        GattCharacteristic *charTable[] = {&weightState};
        GattService         weightService(WEIGHT_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));

        ble.gattServer().addService(weightService);
    }

    //GattAttribute::Handle_t getValueHandle() const
//    {
//        return weightState.getValueHandle();
//    }
    void updateWeight(float newValue)
    {
//        float newWeight = (float) newValue;
//        ble.gattServer().write(weightState.getValueHandle(), 
//        (uint8_t *)&newWeight, sizeof(float));
        WeightType_t weight;
        weight.integer = (int32_t)newValue;
        float f_decimal = newValue - weight.integer;
        weight.decimal = (uint8_t)(f_decimal* 100.0f);
        ble.gattServer().write(weightState.getValueHandle(), 
        (uint8_t *)&weight, sizeof(WeightType_t));
    }

private:
//    WeightType_t                      weight;
    BLEDevice                         &ble;
    ReadOnlyGattCharacteristic<WeightType_t> weightState;
};

#endif /* #ifndef __BLE_WEIGHT_SERVICE_H__ */
