#include "mbed.h"
#include "ADS1256.h"

#define SPI_MOSI  D11
#define SPI_MISO  D12
#define SPI_SCLK  D13
#define CHIP_SLCT D9
#define CHANNEL_NUM 4

#define NO_OF_SENSORS  4 // 1- 1 sensor, 2- 2 sensors, 3- 3 sensors, 4- 4 sensors

DigitalIn ndrdy =  D10;
DigitalOut cs = CHIP_SLCT;

Serial pc(USBTX, USBRX); 

SPI spi(SPI_MOSI, SPI_MISO, SPI_SCLK);
ADS1256 ads(&spi, &ndrdy, &cs);

int32_t ads_sum = 0;

/* 
    @brief: Settling time using the Input Multiplexer.
*/
#if NO_OF_SENSORS == 1
    void readDataMux()
    {
        uint8_t channel = 0;
        ads.readDiffChannel(channel);    

        for (int i=0; i<CHANNEL_NUM; i++)
        {
            ads_sum+= ads.adcNow[i];
        }
    }
#elif NO_OF_SENSORS == 2
    void readDataMux()
    {
        uint8_t channel = 0;
        while(channel < (CHANNEL_NUM-2))
        {
            ads.readDiffChannel(++channel);    
        } 
        channel = 0;
        for (int i=0; i<CHANNEL_NUM; i++)
        {
            ads_sum+= ads.adcNow[i];
        }
    }
#elif NO_OF_SENSORS == 3
    void readDataMux()
{
    uint8_t channel = 0;
    while(channel < CHANNEL_NUM-1)
    {
        ads.readDiffChannel(++channel);    
    } 
    channel = 0;
    for (int i=0; i<CHANNEL_NUM; i++)
    {
        ads_sum+= ads.adcNow[i];
    }
}
#elif NO_OF_SENSORS == 4
    void readDataMux()
        {
            uint8_t channel = 0;
            while(channel < CHANNEL_NUM)
            {
                ads.readDiffChannel(++channel);    
            } 
            channel = 0;
            for (int i=0; i<CHANNEL_NUM; i++)
            {
                ads_sum+= ads.adcNow[i];
            }
        }
#else
       void readDataMux()
       {
            pc.printf("INVALID NUMBER OF SENSORS INITIALIZED\n");
       }
#endif

void process(void)
{

    readDataMux();
    pc.printf("The total value read is %d\n", ads_sum);
    ads_sum=0;
    wait_us(1000);

    pc.printf("The value in adcNow[0] is %d\n", ads.adcNow[0]);
    pc.printf("The value in adcNow[1] is %d\n", ads.adcNow[1]);
    pc.printf("The value in adcNow[2] is %d\n", ads.adcNow[2]);
    pc.printf("The value in adcNow[3] is %d\n", ads.adcNow[3]);
}

int main()
{
    /* @brief Set the configuration parameters:
        channel == 0(0x01h),
        PGA gain == 64,
        Buffer == 1 (enabled),
        Datarate == 2.5SPS.
        Auto_calibration has also been enabled
     */
    ads.cfgADC();
    pc.printf("Device configuration is successful\n");
    ads.setDiffChannel(); // Redundancy feature just to ensure that the channel is set correctly.
    pc.printf("The set gain value is %d\n", ads.getGainVal());
    
    /*TODO: Calibration*/
    ads.selfCal();
    ads.sysOffCal();
    
    while(1) 
    {
        process();
        wait_ms(500);
    }
}
