/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_ADS1256_SERVICE_H__
#define __BLE_ADS1256_SERVICE_H__

typedef struct {
    int32_t integer;
    uint8_t decimal;    
}PACKED Ads1256_t;

class ADS1256Service {
public:
    const static uint16_t ADS1256_SERVICE_UUID              = 0xA000;
    const static uint16_t ADS1256_CHARACTERISTIC_UUID = 0xA001;

    ADS1256Service(BLE &_ble, Ads1256_t ads1256InitialReading) :
        ble(_ble), ads1256State(ADS1256_CHARACTERISTIC_UUID, &ads1256InitialReading, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&ads1256State};
        GattService         ads1256Service(ADS1256_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(ads1256Service);
    }

    void updateAds1256State(float newValue) {
        Ads1256_t adsReading;
        adsReading.integer = (int32_t)newValue;
        adsReading.decimal = (newValue-adsReading.integer)*100; //To 2 decimal places
        ble.gattServer().write(ads1256State.getValueHandle(), (uint8_t *)&adsReading, sizeof(Ads1256_t));
    }

private:
    BLE                              &ble;
    ReadOnlyGattCharacteristic<Ads1256_t>  ads1256State;
};

#endif /* #ifndef __BLE_BUTTON_SERVICE_H__ */
