#ifndef __ADS1256_H__
#define __ADS1256_H__

#define ADS1256_SPI_MODE 1
#define DRATE_MAX 16
#define DEBUG

#define ADS1256_GAIN_1 0 /* GAIN   1 */
#define ADS1256_GAIN_2 1  /*GAIN   2 */
#define ADS1256_GAIN_4 2  /*GAIN   4 */
#define ADS1256_GAIN_8 3  /*GAIN   8 */
#define ADS1256_GAIN_16 4  /* GAIN  16 */
#define ADS1256_GAIN_32 5  /*GAIN    32 */
#define ADS1256_GAIN_64 6  /*GAIN    64 */


#define ADS1256_30000SPS 15
#define ADS1256_15000SPS 14
#define ADS1256_7500SPS 13
#define ADS1256_3750SPS 12
#define ADS1256_2000SPS 11
#define ADS1256_1000SPS 10
#define ADS1256_500SPS 9
#define ADS1256_100SPS 8
#define ADS1256_60SPS 7
#define ADS1256_50SPS 6
#define ADS1256_30SPS 5
#define ADS1256_25SPS 4
#define ADS1256_15SPS 3
#define ADS1256_10SPS 2
#define ADS1256_5SPS 1
#define ADS1256_2d5SPS 0


class ADS1256
{
    SPI *spi;
    DigitalOut *cs;
    DigitalIn *nrdy;
    
    public:
    ADS1256(SPI *, DigitalIn *, DigitalOut *);
    uint8_t gain;
    uint8_t dataRate;
    int32_t adcNow[8];          /* ADC  Conversion value */
    uint8_t channel;            /* The current channel*/
    uint8_t prevChannel;        /* The previous channel --when muxing */
    uint8_t scanMode;   /*Scanning mode,   0 = Single-ended input  8 channel; 1= Differential input  4 channels*/
    uint8_t buffer_en;
    uint32_t maxWaitDelay_us;
        /* gain channelî */

    
    /* Sampling speed choice*/
    /* 
        11110000 = 30,000SPS (default)
        11100000 = 15,000SPS
        11010000 = 7,500SPS
        11000000 = 3,750SPS
        10110000 = 2,000SPS
        10100001 = 1,000SPS
        10010010 = 500SPS
        10000010 = 100SPS
        01110010 = 60SPS
        01100011 = 50SPS
        01010011 = 30SPS
        01000011 = 25SPS
        00110011 = 15SPS
        00100011 = 10SPS
        00010011 = 5SPS
        00000011 = 2.5SPS
    */

    
    /*Register definitions Table 23. Register Map --- ADS1256 datasheet Page 30*/
    enum
    {
        /*Register address, followed by reset the default values */
        REG_STATUS = 0, // x1H
        REG_MUX    = 1, // 01H
        REG_ADCON  = 2, // 20H
        REG_DRATE  = 3, // F0H
        REG_IO     = 4, // E0H
        REG_OFC0   = 5, // xxH
        REG_OFC1   = 6, // xxH
        REG_OFC2   = 7, // xxH
        REG_FSC0   = 8, // xxH
        REG_FSC1   = 9, // xxH
        REG_FSC2   = 10, // xxH
    };
    
    /* Command definition£º TTable 24. Command Definitions --- ADS1256 datasheet Page 34 */
    enum
    {
        CMD_WAKEUP  = 0x00, // Completes SYNC and Exits Standby Mode 0000  0000 (00h)
        CMD_RDATA   = 0x01, // Read Data 0000  0001 (01h)
        CMD_RDATAC  = 0x03, // Read Data Continuously 0000   0011 (03h)
        CMD_SDATAC  = 0x0F, // Stop Read Data Continuously 0000   1111 (0Fh)
        CMD_RREG    = 0x10, // Read from REG rrr 0001 rrrr (1xh)
        CMD_WREG    = 0x50, // Write to REG rrr 0101 rrrr (5xh)
        CMD_SELFCAL = 0xF0, // Offset and Gain Self-Calibration 1111    0000 (F0h)
        CMD_SELFOCAL= 0xF1, // Offset Self-Calibration 1111    0001 (F1h)
        CMD_SELFGCAL= 0xF2, // Gain Self-Calibration 1111    0010 (F2h)
        CMD_SYSOCAL = 0xF3, // System Offset Calibration 1111   0011 (F3h)
        CMD_SYSGCAL = 0xF4, // System Gain Calibration 1111    0100 (F4h)
        CMD_SYNC    = 0xFC, // Synchronize the A/D Conversion 1111   1100 (FCh)
        CMD_STANDBY = 0xFD, // Begin Standby Mode 1111   1101 (FDh)
        CMD_RESET   = 0xFE, // Reset to Power-Up Values 1111   1110 (FEh)
    };

    


    
    //declare functions
    void setSpi(void);
    void cfgADC(void);
    void delayDATA(void);
    void writeReg(uint8_t _RegID, uint8_t _RegValue);
    uint8_t readReg(uint8_t _RegID);
    void writeCmd(uint8_t _cmd);
    uint8_t readChipID(void);
    void setChannel();
    void setDiffChannel();
    void waitDRDY(void);
    void waitNDRDY(void);
    int32_t readData(void);
    uint8_t getGainVal(void);
    void isr(void);
    uint8_t scan(void);
    uint16_t voltageConvert(float Vref, float voltage);
    void readDiffChannel(uint8_t);
    uint32_t getDataRateVal_us(uint8_t);
    void getMaxWaitDelay_us(void);
    void resync(void);
    void selfCal(void);
    void sysOffCal(void);
    void readSingleChannel(void);

};

#endif