#include "mbed.h"
#include "C12832.h"

Ticker Acquisition;
AnalogOut Out(p18);
AnalogIn In(p17);

C12832 lcd(p5, p7, p6, p8, p11);

static unsigned char Echant_Ok = 0;

const int C_continu  = 2048;

char buffer_can_logarithmique[100] = {};
char buffer_in[100] = {};
char buffer_filtre[100] = {};

//static float a[] = {};
//static float b[] = {};

static float En[2] = {0,0};
static float Sn[3] = {0,0,0};

/**
Taille des variables en memoire :
    * short int = 2 octets = 8 bits
    * int = 4 octets = 16 bits
    * float = 4 octets = 32 bits
    * double = 8 octect = 256 bits
**/


// Fonction Echantillonnage
void Echantillonage() {
  Echant_Ok=1;
}

double CAN_log_func(int x){
    double y = 0;
    
    if (x > 0 && x <= 32){
        y = x * 16;
    } else if (x > 0 && x <= 32){
        y = x * 8 - 1/8;
    } else if (x > 32 && x <= 64){
        y = x * 4 + 1/4;
    } else if (x > 64 && x <= 128){
        y = x * 2 + 3/8;
    } else if (x > 128 && x <= 256){
        y = x + 1/2;
    } else if (x > 256 && x <= 512){
        y = x * 1/2 + 5/8;
    } else if (x > 512 && x <= 1024){
        y = x * 1/4 + 3/4;
    }
    return y;
}

float Filtrage(int x){
    return (0.1*En[0]-0.0897*En[1]+1.55952*Sn[1]-0.6065*Sn[2]);
}

int main(){
  // Declanchement de la fonction d'échantillonnage
  Acquisition.attach_us(&Echantillonage,125);
  
  // Boucle infini
  while (true) {
    if (Echant_Ok == 1) {
        // Quantification
        int entree_uni = In.read_u16();
        int entree_log = CAN_log_func(entree_uni - C_continu);

        En[1] = En[0];
        En[0] = entree_log;
        
        Sn[2] = Sn[1];
        Sn[1] = Sn[0];
        Sn[0] = Filtrage(En[0]);
        
        sprintf(buffer_in, "Valeur : %d | %d", entree_uni, (entree_uni - C_continu));
        sprintf(buffer_can_logarithmique, "Quantification : %d", entree_log);
        sprintf(buffer_filtre, "En=%d | Sn=%f", entree_log, Filtrage(entree_log));
        
        lcd.locate(0,3);
        lcd.printf(buffer_in);
        
        lcd.locate(0,11);
        lcd.printf(buffer_can_logarithmique);
        
        lcd.locate(0,19);
        lcd.printf(buffer_filtre);
        
    }
    Echant_Ok = 0;
  }
}
