#ifndef MBED_XBEE_TX_H
#define MBED_XBEE_TX_H

// API Frame Names      API ID
#define AT_CMD          0x08
#define AT_CMD_QUEUE    0x09
#define ZBEE_TX_RQST    0x10
#define RMT_CMD_RQST    0x17
#define CREATE_SRC_R    0x21
#define AT_CMD_RSPNS    0x88
#define MODEM_STATUS    0x8A
#define ZBEE_TX_STATUS  0x8B
#define RMT_CMD_RSPNS   0x97

#define START         0x7E
#define CMD_AT        0x08
#define CMD_TX_RQST   0X10
#define RMT_CMD_RQST  0X17
#define PLUS          0x2B
#define FRM_ID_01     0x01
#define MODEM_STATUS  0x01

uint16_t PAN_ID                = 0;
uint16_t FREQ_LECTURE_CAPTEURS = 0; 

// Fonctions communication entre LPC1768 et XBee
bool send_char_2Xbee(uint8_t caratere);
bool    send_2Xbee(uint8_t *message_2_send, uint16_t nbr_char);
bool    receive_Xbee();
void    init_xbee(uint16_t pan_id);
uint8_t checksum_calc(uint8_t cmdID, uint8_t frameID, uint8_t *data, uint16_t nbr_char);
bool    send_frame_2Xbee(uint8_t cmdID, uint8_t frameID, uint8_t *data_2_send, uint16_t nbr_char);
bool    get_coord_ID();
uint8_t get_MSB(uint16_t length);
uint8_t get_LSB(uint16_t length);

#endif