//          TELEMETRÍA

//   Aura María Duque Muñoz
//   Esteban Gómez Barrientos
//  

#include "mbed.h"
#include "DebouncedIn.h"
#include "stdio.h"
#include "string.h"


Timer t;
DigitalOut LedVerde(LED2);
DigitalOut LedRojo(LED1);
DigitalOut LedAzul(LED3);
DigitalOut LedR(PTD5);
DigitalOut LedV(PTD0);
DigitalOut LedA(PTD2);
DebouncedIn button1(PTC12);  // Inicia envío del mensaje Alarma 1
DebouncedIn button2(PTC13);  // Inicia envío del mensaje Alarma 2
DebouncedIn button3(PTC16);  // Inicia envío del mensaje Alarma 3
Serial GSM(PTE0,PTE1);       // Configura puerto UART de la FRDMKL25Z
Serial pc(USBTX,USBRX);      // Configura puerto USB a la consola serial del PC conectado.

void Rx_interrupt();
int position=0;
int lenpack=6;
int longi=0;
char tel[10];
char DE[50];
char buffer[512];
char NUMBER[13];    
int index;
int count;
int i = 0;
int c=0;
unsigned char CtrlZ = 0x1A;  // Comodín de emisión controlZ
bool Flag = false;           // Bandera 
char r[]="";                 // Cadena de recepcion de la trama PDU
char msg[256];
char char1;
//Flush serial para el buffer
void FlushGSM(void) { 
char1 = 0;
 while (GSM.readable()){
     char1 = GSM.getc();}
     return;}

void callback() {
    // Nota: Se necesita actualizar la lectura del puerto serial para borrar la interrupción de RX
      pc.printf("%c\n", GSM.getc());
    
}
 
int readBuffer(char *buffer,int count)
{
    int i=0; 
    t.start();          // Inicia el timer
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
        if(i > count)break;
        if(t.read() > 3) {
            t.stop();
            t.reset();
            break;
        }
    }
    wait(0.5);
    while(GSM.readable()) {     // Muestra otra cosa
        char c = GSM.getc();
    }
    return 0;
}

/* Esta función limpia o borra todo un "buffer" de tamaño "count"
lo revisa uno por un elemento y le mete el caracter null que indica fin de cadena
no retorna nada
*/
//***************************************************************************************
void cleanBuffer(char *buffer, int count)
{
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}
/* Esta función envía un comando parametrizado como cadena
*/
//***************************************************************************************
void sendCmd(char *cmd)
{
    GSM.puts(cmd);
}
/* Esta función espera la respuesta de un comando que debe ser idéntica a la cadena "resp" y un tiempo timeout"
si todo sale bien retorna un cero que en la programacion. Hay que validar
si algo sale mal ( no se parece o se demora mucho )retorna -1 que debera validarse con alguna expresión lógica
*/
//***************************************************************************************
int waitForResp(char *resp, int timeout)
{
    int len = strlen(resp);
    int sum=0;
    t.start();

    while(1) {
        if(GSM.readable()) {
            char c = GSM.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;   // Esta línea de C# sum se incrementa o se hace cero según c
            if(sum == len)break;                // Acaba y sale
        }
        if(t.read() > timeout) {                // timeout chequea el tiempo mínimo antes de salir perdiendo
            t.stop();
            t.reset();
            return -1;
        }
    }
    t.stop();                    //  Para timer  antes de retornar
    t.reset();                   //  Borra timer
    while(GSM.readable()) {      //  Muestra otra cosa
        char c = GSM.getc();
    }

    return 0;
}
/* Esta función es  completa y útil, se encarga de enviar el comando y esperar la respuesta
si todo sale bien retorna un cero(herencia de las funciones contenedoras) que en la programación hay que validar
con alguna expresión lógica
*/

void Rx_interrupt(){
     }

//***************************************************************************************
int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout)
{
    sendCmd(cmd);
    return waitForResp(resp,timeout);
}
/* Esta función chequea que el modem este conectado,  envía AT y le contesta con OK; espera 2 segundos.
*/
//***************************************************************************************
int powerCheck(void)// Este comando sirve para verificar si el modem esta conectado.
{
    return sendCmdAndWaitForResp("AT\r\n", "OK", 2);    
}
/* Eta función chequea el estado de la sim card
si todo sale bien retorna un cero que en la programación hay que válidar con alguna expresión lógica
*/
//***************************************************************************************
int checkSIMStatus(void)
{
    char gprsBuffer[30];
    int count = 0;
    cleanBuffer(gprsBuffer,30);
    while(count < 3) {
        sendCmd("AT+CPIN?\r\n");
        readBuffer(gprsBuffer,30);
        if((NULL != strstr(gprsBuffer,"+CPIN: READY"))) {
            break;
        }
        count++;
        wait(1);
    }

    if(count == 3) {
        return -1;
    }
    return 0;
}
/* Esta función chequea la calidad de la señal, si todo sale bien retorna el valor de señal util o un -1 si no es aceptable,
 en la programación hay que validar con alguna expresión lógica
*/
//***************************************************************************************
int checkSignalStrength(void)
{
    char gprsBuffer[100];
    int index,count = 0;
    cleanBuffer(gprsBuffer,100);
    while(count < 3) {
        sendCmd("AT+CSQ\r\n");
        readBuffer(gprsBuffer,25);
        if(sscanf(gprsBuffer, "AT+CSQ$$$$+CSQ: %d", &index)>0) {
            break;
        }
        count++;
        wait(1);
    }
    if(count == 3) {
        return -1;
    }
    return index;
}

/* esta funcion de abajo configura el modem de forma inicial con comandas AT
y si todo sale bien retorna un cero que en la programacion hay que validar
con alguna expresion logica pero si algo sale mal retorna un -1
*/

//***************************************************************************************
/*int settingSMS() //esta funcion se invoca para configurar el modem al principio
{
    if(0 != sendCmdAndWaitForResp("AT\r\n", "OK", 1)) {
        return -1;
    }
    if(0 != sendCmdAndWaitForResp("AT+CNMI=1,1\r\n", "OK", 1)) {
        return -1;
    }
    if(0 != sendCmdAndWaitForResp("AT+CMGF=0\r\n", "OK", 1)) {
        return -1;
    }
    if(0 != sendCmdAndWaitForResp("ATE\r\n", "OK", 1)) {
        return -1;
    }
    if(0 != sendCmdAndWaitForResp("CBST=0,0,1\r\n", "OK", 1)) {
        return -1;
    }
    return 0;
}
*/
 
/* Esta función inicaliza el modem, se compone de un grupo de subfunciones ya definidas previamente
1) chequea que este conectado.
2) chequea el estado de la simcard.
3) chequea la intencidad de señal celular
4) aplica la configuración.
y si todo sale bien retorna un cero que en la programación hay que válidar con alguna expresión lógica
*/
//***************************************************************************************
int init()
{
    for(int i = 0; i < 3; i++){
        sendCmdAndWaitForResp("AT\r\n", "OK", 1);
        wait(0.5);
    }
    if(0 != checkSIMStatus()) {
        return -1;
    }
    if(checkSignalStrength()<1) {
        return -1;
    }
   
    GSM.attach(&Rx_interrupt, Serial::RxIrq);
    return 0;
}
/* Esta función intenta leer un mensaje de texto en formato PDU o HEX
 si todo sale bien retorna un cero que en la programación hay que válidar con alguna expresión lógica
*/
//***************************************************************************************
int readSMSpdu(char *message, int index)
{
    int i = 0;
    char gprsBuffer[100];
    char *p,*s;
    GSM.printf("AT+CMGR=%d\r\n",index);
    cleanBuffer(gprsBuffer,100);
    readBuffer(gprsBuffer,100);
    if(NULL == ( s = strstr(gprsBuffer,"+CMGR"))) {
        return -1;
    }
    if(NULL != ( s = strstr(gprsBuffer,"+32"))) {
        p = s + 6;
        while((*p != '$')&&(i < 5)) {
            message[i++] = *(p++);
        }
        message[i] = '\0';
    }
    return 0;
}
/* Esta función borra mensajes SMS del modem, si todo sale bien retorna un cero que en la programación hay que válidar
con alguna expresión lógica
*/
//***************************************************************************************
int deleteSMS(int index)
{
    char cmd[32];
    snprintf(cmd,sizeof(cmd),"AT+CMGD=%d\r\n",index);
    sendCmd(cmd);
    return 0;
}
//*************************************************************************************

int main(void)
       { 
       char bufferp[4]; 
       char bufferp2[85];
       bufferp2[72]=0; 
       bufferp2[73]=0; 
           
       //NVIC_DisableIRQ(UART1_IRQn); 
             
       //Se apagan los leds
       
       LedVerde=1;
       LedRojo=1;
       LedAzul=1;
       lenpack=6;                      //Tamaño de "ALARMA"
       GSM.baud(9600);                  //Configura los baudios de la FRDMKL25Z en 9600
       GSM.format(8,Serial::None,1);    //Configura el formato de los datos de la UART
       
       //Se configura el modem GSM
       GSM.printf("AT\r\n");
       wait(0.5);
       GSM.printf("AT+CNMI=1,1\r\n");
       wait(0.5);
       GSM.printf("AT+CMGF=0\r\n");
       wait(0.5);
       GSM.printf("ATE\r\n");
       wait(0.5);
       GSM.printf("CBST=0,0,1\r\n");
       wait(0.5);  
       LedVerde=0;     
      
       while(1){
//********************************************************************************************        
if (button1.falling())
    { LedVerde=1;
       wait(2);
            if (!button1)
                {
                   LedVerde=0;
                   index=20;
                   //GSM.printf("AT+CNMI=1,1\r\n"); //configuracion inicial del MODEM!
                   GSM.printf("AT+CMGS=%d\r\n",index);
                   wait(0.2);
                   GSM.printf("0011000A9113633863070000AA08416650DA0C8262"); // "ALARMA 1"
                   wait(0.5);
                   GSM.putc((char)0x1A); //controlZ   
                   LedVerde=1;
                   LedRojo=0;  // Se prende led
                   wait(3);
                   LedRojo=1;  // Se apaga led
                   LedVerde=0;          
                   }
           }

// Se realiza el mismo procedimiento para los otros dos leds.

if (button2.falling())
        { 
                LedVerde=1;
                  wait(2);
       if (!button2)
          {     LedVerde=0;
                   index=20;
               //GSM.printf("AT+CNMI=1,1\r\n"); //configuracion inicial del MODEM!
               GSM.printf("AT+CMGS=%d\r\n",index);
               wait(0.2);
               GSM.printf("0011000A9113633863070000AA08416650DA0C8262"); // "ALARMA 2"
               wait(0.5);
               GSM.putc((char)0x1A); // controlZ   
               LedVerde=1;
               LedRojo=0;  // Se prende led.
               wait(3);
               LedRojo=1;  // Se aparag led.
               LedVerde=0;          
               }
       }
       
if (button3.falling())
      { LedVerde=1;
          wait(2);
           if (!button3)
           {LedVerde=0;
               index=20;
           //GSM.printf("AT+CNMI=1,1\r\n"); //configuracion inicial del MODEM!
           GSM.printf("AT+CMGS=%d\r\n",index);
           wait(0.2);
           GSM.printf("0011000A9113633863070000AA08416650DA0C8262"); //"ALARMA 3"
           wait(0.5);
           GSM.putc((char)0x1A); // controlZ   
           LedVerde=1;
           LedRojo=0;  // Se prende led.
           wait(3);
           LedRojo=1;  // Se apaga led.
           LedVerde=0;          
              }
        }
//*************************************************************************************************

if (GSM.readable()) {
            readBuffer(buffer,100);
            pc.printf("buffer= %s\n\r ",buffer);
            pc.printf("buffer= %c  %c\n\r ",buffer[10],buffer[11]);
                if(buffer[67]=='A'){for(i=0;i<86;i++)
                 {bufferp2[i]=buffer[i];}
                 pc.printf("bufferp2= %s\n\r ",bufferp2); 
                 pc.printf("bufferp2[72]= %c bufferp2[73]=%c\n\r ",bufferp2[72],bufferp2[73]);        
                 buffer[67]='c';
                 }
               
               
                }
 
       
 if(buffer[10]=='S'&& buffer[11]=='M'){
             for(i=0;i<5;i++)
             {bufferp[i]=buffer[2+i];}
             pc.printf("bufferp= %s\n\r ",bufferp);         
             buffer[10]='c';
             buffer[11]='c';
             }
if(bufferp[3]=='T'){pc.printf("AT+CMGL=0\n\r");
            wait(0.5);
            GSM.printf("AT+CMGL=0\r\n");
            bufferp[3]='p';
            }
if(bufferp2[72]=='7' && bufferp2[73]=='7'){LedA=1;}
if(bufferp2[72]=='F' && bufferp2[73]=='7'){LedV=1;}
if(bufferp2[72]=='B' && bufferp2[73]=='7'){LedR=1;}
if(bufferp2[72]=='7' && bufferp2[73]=='3'){LedA=0;}
if(bufferp2[72]=='F' && bufferp2[73]=='3'){LedV=0;}
if(bufferp2[72]=='B' && bufferp2[73]=='3'){LedR=0;}                 
         
    }
       
 }     