#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"


TextLCD lcd(PTB0, PTB1, PTB2, PTB3, PTC2, PTC1); // rs, e, d4, d5, d6, d7
Rtc_Ds1307 rtc(PTE0, PTE1);
QEI wheel (PTD7, PTD6, NC, 30);
DebouncedIn button_enco(PTC5);
PwmOut PIDWM(PTC9);
PwmOut PIDANAL(PTE24);
DigitalOut Sel(PTE31);
AnalogIn y(PTE16);
float periodo;
float Frecuencia=200;
int C1=0x0C;
int m;
int Conf=0;  // 
int Lugar=0; // Definen el punto en el cual va el programa
int i=0;
int Ref = 0, Kp = 0, Ti = 0, Td = 0; 
float t1 = 0, t2 = 0, t3 = 0, ai = 0, ap = 0, ad = 0, pid = 0, med = 0, RefPID = 0,Taza = 0, o = 0;
float err = 0, err_v = 0;

int main()
{
    Rtc_Ds1307::Time_rtc tm = {};
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(0,0);
    lcd.printf("--ANALOG  --PWM");
    
    periodo=(1/Frecuencia);
    rtc.getTime(tm); //lee el tiempo del DS1307
    Sel = 1;
    while(1)
    {
        switch (Lugar)
        {
            case 0:
                m=wheel.getPulses();  // m son los datos del encoder
                if(m!=0 && Conf==0){
                    Conf=1;
                    wheel.reset();  
                    m=0;              
                }
                
                 if(m!=0 && Conf==1){
                    Conf=0;
                    wheel.reset();  
                    m=0;              
                }
                if(Conf==0){
                    
                    lcd.locate(11,0);
                    lcd.printf("-");                    
                    lcd.locate(1,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                    
                }
                
                 if(Conf==1){
                    
                    lcd.locate(1,0);
                    lcd.printf("-");                    
                    lcd.locate(11,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                }
                
                if (button_enco.falling()){  //si se pulsa boton encoder
                    Lugar++;
                    m=0;       
                }
            
            break;
            
            case 1:
                switch(i)
                {
                    case 0:
                    
                                              
                        if(Conf==0)
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Parametros");
                            wait(1);
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Ref:     Kp:  ");
                            lcd.locate(0,1);
                            lcd.printf("Ti:      Td:  ");                             
                        }
                
                        if(Conf==1)
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Parametros");
                            wait(1);
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Ref:     Kp:  ");
                            lcd.locate(0,1);
                            lcd.printf("Ti:      Td:  ");  
                        }    

                    break;
                    
                    case 1:
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            Ref=Ref+m;
                            if(Ref>99)
                            {
                                Ref=99; // Configuracion de la ref para analg
                            }
                            if(Ref<0)
                            {
                                Ref=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(5,0);
                        lcd.printf("%02d",Ref);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.locate(13,0);
                            //tm.mon=1;
                        }
                    
                    break;
                    
                    case 2:
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            Kp=Kp+m;
                            if(Kp>99)
                            {
                                Kp=99;
                            }
                            if(Kp<0)  // Configuracion de Kp para analg
                            {
                                Kp=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(13,0);
                        lcd.printf("%02d",Kp);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.locate(4,1);                            
                        }
                    
                    break;
                    
                    case 3:
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            Ti=Ti+m; // Configuracion de Ti para analg
                            
                            if(Ti>99)
                            {
                                Ti=99;
                            }
                            if(Ti<0)  
                            {
                                Ti=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(4,1);
                        lcd.printf("%02d",Ti);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.locate(13,1);
                            
                        }
                    
                    break;
                    
                     case 4:
                        m=wheel.getPulses();
                                
                        if (m!=0) 
                        {
                            Td=Td+m; // Configuracion de Ti para analg
                            
                            if(Td>99)
                            {
                                Td=99;
                            }
                            if(Td<0)  // Configuracion de Td para analg
                            {
                                Td=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(13,1);
                        lcd.printf("%02d",Td);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("t1:     t2:  ");
                            lcd.locate(0,1);
                            lcd.printf("t3:  ");
                            lcd.locate(4,0);
                        }
                    break;
                    
                     case 5:
                        m=wheel.getPulses();
                        if (m!=0) 
                        {
                            t1=t1+m; // Configuracion de Ti para analg
                            if(t1>60)
                            {
                                t1=60;
                            }
                            if(t1<0)  // Configuracion de Td para analg
                            {
                                t1=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(4,0);
                        lcd.printf("%.1f",t1);
                        
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.locate(12,0);
                        }
                    
                    break;
                    
                     case 6:
                        m=wheel.getPulses();
                                
                        if (m!=0) 
                        {
                            t2=t2+m; // Configuracion de Ti para anal
                            if(t2>60)
                            {
                                t2=60;
                            }
                            if(t2<0)  // Configuracion de Td para analg
                            {
                                t2=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(12,0);
                        lcd.printf("%.1f",t2);
                        
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.locate(4,1);
                        }
                    
                    break;
                    
                     case 7:
                        m=wheel.getPulses();
                                
                        if (m!=0) 
                        {
                            t3=t3+m; // Configuracion de Ti para analg
                            if(t3>60)
                            {
                                t3=60;
                            }
                            if(t3<0)  // Configuracion de Td para analg
                            {
                                t3=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(4,1);
                        lcd.printf("%.1f",t3);
    
                        if (button_enco.falling())
                        {
                            ///////////////////
                            if(Conf==0 || Conf==1)
                            {
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf(" Parametros OK ");
                                wait(1);
                                i=0;
                                m=0;
                                Lugar++;
                                lcd.cls();
                                tm.sec = 0;
                                tm.min = 0;
                                tm.hour = 1;
                                tm.date = 1;
                                tm.mon = 1;
                                tm.year = 2000;
                                PIDWM.pulsewidth(0);
                                rtc.setTime(tm,false,false);
                                rtc.startClock();
                                                                 
                            }
                           ///////////////////
                        }
                        break;
                        }
                    break;
                    case 2:
                    if (Conf == 1 || Conf == 0){
                         
lop1:                    med = y.read()*100;
                         rtc.getTime(tm);
                         if ((tm.sec)<t1)
                         {
                                Taza = Ref/t1;
                                RefPID = tm.sec*Taza;
                         }
                         if ((tm.sec)>=t1 && (tm.sec)<=(t2+t1)){
                                RefPID = Ref;
                         }
                         if ((tm.sec)>(t2+t1)){
                                if (RefPID<23){
                                    RefPID=23;
                                    }
                                    else if (RefPID>23){
                                Taza = (23-Ref)/t3/60;
                                RefPID = RefPID + tm.sec*Taza;
                                }
                         }
                         if ((tm.sec)>(t1+t2+t3) && med < 23){
                                RefPID = 23;  
                         }
                         err = (RefPID-med);  //se calcula el error
                         ap = Kp*err*0.01f;     //se calcula la accion proporcinal
                         ai =(Ti*err*0.01f)+ai;    //calculo de la integral del error
                         ad = Td*(err-err_v)*0.01f; //calculo de la accion derivativa
                         pid = (ap+ai+ad);
                         // se verifica que pid sea positivo **************************************
                         if(pid<=0)
                         {
                         pid=0;
                         }
 
                         // se verifica que pid sea menor o igual la valor maximo *****************
                         if (pid > 100)
                         {
                         pid=100;
                         }
 
       
                          //se muestran las variables******************************************
                         lcd.locate(1,0);
                         lcd.printf("err:     med:");
                         lcd.locate(4,0);
                         lcd.printf("%3.0f",err);
                         lcd.locate(13,0);
                         lcd.printf("%3.0f",med);
                         lcd.locate(1,1);
                         lcd.printf("Ref:     pid:");
                         lcd.locate(4,1);
                         lcd.printf("%3.0f",RefPID);
                         lcd.locate(13,1);
                         lcd.printf("%3.0f",pid);
           
            
        
 
                        //Normalizacion de la salida
                        // se actualizan las variables *******************************************
                         err_v = err;
                         o = pid/100;
                             PIDWM.pulsewidth(o*periodo);
                         //  se envia el valor pid a puerto analogico de salida (D/A) **************
        
                         //  se repite el ciclo
                         wait_ms(100);
                         goto lop1;
                        }
                    }
        }         
    }
                