#include "Sheald_BLE.h" 
#include "LOGGER.h"

static Logger *Ordi = Logger::Instance();

STM32_BLE::STM32_BLE()
{
  char tmp[]= "BlueNRG_UART";
  DEVICE_NAME= tmp;
   c = 'A';
  connected = false;
  UpdatedEnabled = false;
 }
/* Callback called when the device is disconnected */
void STM32_BLE::disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
  Ordi->log("Disconnected!\n\r");
  Ordi->log("Restarting the advertising process\n\r"); 
  ble.startAdvertising();
  connected = false;
}
 
/* Callback called when the device is connected */
void STM32_BLE::connectionCallback(Gap::Handle_t handle, const Gap::ConnectionParams_t *reason)
{
  Ordi->log("Connected ");
 
  connected = true;
}

/* Callback called when the client enables updates */
void STM32_BLE::onUpdatesEnabled(uint16_t attributeHandle)
{
  Ordi->log("**onUpdatesEnabled** ");
  UpdatedEnabled = true;
}
 
/* Callback called when the client disable updates */
void STM32_BLE::onUpdatesDisabled(uint16_t attributeHandle)
{
  Ordi->log("**onUpdatesDisabled** ");
  UpdatedEnabled = false;
}
 
/* Main */
bool STM_32::init()
{
  Ordi->log("Initialising ");
  ble.init();
#if 1
/* Set callback functions */
  ble.onDisconnection(disconnectionCallback);
  ble.onConnection(connectionCallback);
  ble.onUpdatesEnabled(onUpdatesEnabled);
  ble.onUpdatesDisabled(onUpdatesDisabled);
 
  DeviceInformationService deviceInfo(ble, "ST", "Nucleo", "SN1", "hw-rev1", "fw-rev1", "soft-rev1");
  /* setup advertising */
  ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
  ble.setAdvertisingType          (GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    
  ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME            , (const uint8_t *)"BlueNRG_UART"          , sizeof("BlueNRG_UART") - 1);
  ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS, (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));
  ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME             , (uint8_t *)DEVICE_NAME                   , sizeof(DEVICE_NAME));
 
  /* Start advertising */
  ble.setAdvertisingInterval(160);
  ble.startAdvertising();
 
  UARTService uartService(ble);
  uartServicePtr = &uartService;
 }
 /*void unchecked()
 {
  while (true) 
  {
    ble.waitForEvent();
        
    if(connected == true)
    {
      if ((user_button_pressed == true) && (UpdatedEnabled == true))
      {
        user_button_pressed = false;
        Ordi->log("Current Char: %c ",c);
        ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), &c, 1);
                
        c++;
                
        if(c == ('Z'+1))
        {
          c = 'A';
        }
      }
    }
  }
#else
  while (true) 
  {
    if (user_button_pressed == true)
    {
      user_button_pressed = false;
      Ordi->log("Current Char: %c ",c);
                
      c++;
                
      if(c == ('Z'+1))
      {
        c = 'A';
      }
    }
  }
#endif
}*/