#ifndef LOGGER_H
#define LOGGER_H
#include "MODSERIAL.h"
#include "mbed.h"
#include <string>
#define <queue>
#define DEBUT_TRAME '!'
#define FIN_TRAME '#'
#define MAX_SIZE_BUFFER 6
class Logger {
    
    public : 
    static Logger* Instance();
    
    void log(std::string s);
    void logn(std::string s);
    void log(double f);
    void logn(double f);
    void log(int i);
    void logn(int i);
    void log(long l);
    void logn(long l);
    string log_itos(int i);
    //buffer
    int get_buffer_index();
    void flush_buffer();
    protected :
    
    static Logger* _instance;
    void rxCallback(MODSERIAL_IRQ_INFO *q);
    Logger();
    MODSERIAL * serial;
    int buffer_index;
    bool new_event, event_detected;
    std::queue<char> *buffer;
    
};

#endif