#include "LOGGER.h"
#include <stdio.h>
#include <cmath>
#include <cstdlib>
#include "Event.h"
#define BUFFER_LENGTH 32

static event *Ev = event::Instance();

Logger* Logger::_instance = NULL;

Logger::Logger()
{
    serial = new MODSERIAL(SERIAL_TX, SERIAL_RX, BUFFER_LENGTH); //32 bitd long
    serial->attach(&rxCallback, MODSERIAL::RxIrq);
    buffer_index = 0 ;
    buffer = new std::queue<char>;
    new_event=false;
    event_detected = false;
}
void Logger::rxCallback(MODSERIAL_IRQ_INFO *q)
{
    char c =serial->getc();
    if(event_detected) {
        if(c != FIN_TRAME) {
            if(buffer_index < MAX_SIZE_BUFFER) {
                buffer_index++;
                buffer.push(c);
            } 
            else { // une erreur c'est produite et ont n'a pas recu la fin du message
                flush_buffer();
                log("Logger::rxCallback Erreur dépassement de la taille maximale du buffer sans recevoire la fin de la trame");
                event_detected = false;
            }
        } 
        else {
            //on a recu la fin de la trame et ont vas reseter et envoyer le message aux gestoinaire d'event
            Ev->give_buffer(&buffer);
            event_detected = false;
            flush_buffer();
            log("Logger::rxCallback On a transferet un buffer au gestionaire d'event aprés reception de signalement de la fin de trame");
        }
    } 
    else { //event hesn't been detected yet
        if(c == DEBUT_TRAME ) {
            event_detected =true;
            log("Logger::rxCallback Debut de trame detecter, ont flush le buffer par precausion ");
            flush_buffer();
        } 
        else {
            log("Logger::rxCallback Incoherant message pas de debut de trame detecter, recu : ");
            log(c);
        }

    }
}

Logger* Logger::Instance()
{
    if (_instance == NULL) _instance = new Logger();
    return _instance;
}

void Logger::log(std::string s)
{
    this->serial->printf((s).c_str());
    this->serial->printf(" ");
}

void Logger::logn(std::string s)
{
    this->log((s+"\n\r").c_str());
}

void Logger::log(double f)
{
    this->serial->printf("%f",f);
    this->log("");
}

void Logger::logn(double f)
{
    this->log(f);
    this->logn("");
}

void Logger::log(int i)
{
    this->serial->printf("%d",i);
    this->log("");
}

void Logger::logn(int i)
{
    this->log(i);
    this->logn("");
}

void Logger::log(long i)
{
    this->serial->printf("%ld",i);
    this->log("");
}

void Logger::logn(long i)
{
    this->log(i);
    this->logn("");
}
string Logger::log_itos(int i)
{
    float v= (float) i;
    char *c =(char*) malloc(sizeof(char)*((int)log10(v)+1));
    sprintf(c,"%d",i);
    return string(c);
}
int Logger::get_buffer_index()
{
    return buffer_index;
}
void Logger::flush_buffer()
{
    if(buffer_index>0) {
        buffer= new std::queue<char>;
        buffer_index=0;
    } else log("Logger::flush_buffer Erreur le buffer est déjà vide");
}
}
