#include "mbed.h"
#include "COM/SSC-32.h"
#include "COM/LOGGER.h"
#include "COM/Event.h"
#include "LIB/Hexapod.h"

static Logger *Ordi = Logger::Instance();
static event *evnt = event::Instance();
int main()
{
    //0.declaration des ressources

    int ii, ij, ik, ix, iy, size, ind;
    int cx, cy, attempts;
    //serial ser;
    hexapod hex;
    //logger log;
    //SDL_Surface *screen;
    //SDL_Event event;
    //SDL_Joystick *joy;
    int dsize, psize;
    double time, lasttime, dt, lastdata, inittime;
    uint8_t errcode;
    float pos, avgtemp, joyval, maxval;
    unsigned char chk;
    bool cont, quit;
    //My adds
    LowPowerTimer time;
    SSC_32 ser;
    //log.init("logfile", true);
    time.start();
    inittime = time.read();

    // max useable speed is 2.0 -> 1 foot per second
    hex.speed = 0.0; // in cycles per second
    hex.turning = 0.0; // [-1,1], rotation in z-axis

    Ordi->log( "Begin IK" );
    // IK test
    time = 0.0;
    lasttime = time.read();
    hex.safeStand();
    while (hex.ssrunning) {
        dt = (time.read() - lasttime);
        lasttime = time.read();
        hex.step(dt);
        // package positions
        for (ii=0; ii<18; ii++) {
            ser.add(ii,hex.servoangle[ii]);

        }
        ser.send();
        wait_us(20*1000);

    }
    lasttime = time.read();
    lastdata = lasttime;
    ser.send();
    wait_us(20*1000);

    quit = false;
    while (!quit) {
        dt = (time.read() - lasttime);
        time += dt;
        lasttime = time.read();
        hex.step(dt);
        // package positions
        for (ii=0; ii<18; ii++) {
            ser.add(ii, hex.servoangle[ii]);
        }
        ser.send();
        // ask for data?

        while (evnt->has_new_event()) {

            if (evnt->has_button_presed()) {
                if (evnt->get_val_B()=='7') quit = true;
            }
            if (evnt->has_J_pressed()) { // J stick, yaxis
                joyval = evnt->get_val_J();
                if (joyval > 0.1) hex.speed = 0.5*(joyval - 0.1);
                else if (joyval < -0.1) hex.speed = 0.5*(joyval + 0.1);
                else hex.speed = 0.0;
            }
            if (evnt->has_T_pressed()) { // T stick, xaxis
                joyval = evnt->get_val_T();
                if (joyval > 0.1) hex.turning = (joyval-0.1);
                else if (joyval < -0.1) hex.turning = (joyval+0.1);
                else hex.turning = 0.0;
            }
            if (evnt->has_R_pressed()) { // R stick, yaxis
                joyval = evnt->get_val_R();
                if (joyval > 0.1) hex.standheight = (joyval-0.1)*2.0;
                else if (joyval < -0.1) hex.standheight = (joyval+0.1)*2.0;
                else hex.standheight = 0.0;
            }

        }
        wait_us(20);
    }

    Ordi->log( "Quitting.." );
    ser.close();
    return 0;
}
