#include "mbed.h"
#include "MPU6050.h"

Ticker Game;
Serial pc(USBTX,USBRX);
SPI device (PB_15,PB_14,PB_13);
DigitalOut ssel(PB_12);
MPU6050 mpu1(PB_9,PB_8);
MPU6050 mpu2(PB_3,PB_10);

// variables
int band=0;
int move1=0,move2=0,col =0,fil =0;
int status =0;
float x[3],y[3];
float aux1=0,aux2 =0;
uint8_t pos[6]={0b11100000,0b01110000,0b00111000,0b00011100,0b00001110,0b00000111};
uint8_t player1[1],player2[1];
uint8_t ball[8]={0b10000000,0b01000000,0b00100000,0b00010000,0b00001000,0b00000100,0b00000010,0b00000001};
uint8_t aux[1],scan[8];

////////////////////////////////////////////////////////////////////////////////
void sendSPI(uint8_t d1, uint8_t d2)
{
    device.unlock();
    ssel=0;
    device.write(d1); 
    device.write(d2);  
    ssel=1;
    device.lock();
};
////////////////////////////////////////////////////////////////////////////////
void clr_vcol()
    {
    for (int i=0; i<8;i++){
            sendSPI(i,0);
    }
    }
////////////////////////////////////////////////////////////////////////////////
void inicializar(){
     
    sendSPI(0x0c,1);
    sendSPI(0x0b,7);
    sendSPI(0x0F,1);
    wait (0.9);
    sendSPI(0x0f,0);
    }
////////////////////////////////////////////////////////////////////////////////
void act_status(void){
    status += 1;
    }
 ///////////////////////////////////////////////////////////////////////////////
int main(){
       
       inicializar();
       Game.attach(&act_status,0.2);
       while (1){
        
        if(status==1){
           mpu1.getAccelero(x);
           //pc.printf("accelero 1: \t X = %f, \t Y = %f, \t Z = %f \n",x[0],x[1],x[2]);
           aux1 = x[0];
           mpu2.getAccelero(y);
           //pc.printf("accelero 2: \t X = %f, \t Y = %f, \t Z = %f \n",y[0],y[1],y[2]);
           aux2 = y[0];
           status = 2;
           }
        if(status ==2){
           
           if(aux1<-8){move1 =0;}                                             
           else if(aux1>-8 && aux1<-4){move1=1;}   
           else if(aux1>-4 && aux1<-1){move1 =2;}
           else if(aux1>1 && aux1<4){move1=3;}    
           else if(aux1>4 && aux1<8){move1=4;}
           else if(aux1>8){move1=5;}
               
           pc.printf("posicion 1: \t %d \n",move1);
           
           if(aux2<-8){move2 =0;}
           else if(aux2>-8 && aux2<-4){move2=1;}   
           else if(aux2>-4 && aux2<-1){move2 =2;}
           else if(aux2>1 && aux2<4){move2=3;}    
           else if(aux2>4 && aux2<8){move2=4;}
           else if(aux2>8){move2=5;}
               
           pc.printf("posicion 2: \t %d \n",move2);
           status =3;           
           }
        
        if(status==3){
           
            switch(move1){
                case 0: player1[0] = pos[0];break;                              //se designa la posicion que va a tener el jugador 1
                case 1: player1[0] = pos[1];break;
                case 2: player1[0] = pos[2];break;
                case 3: player1[0] = pos[3];break;
                case 4: player1[0] = pos[4];break;
                case 5: player1[0] = pos[5];break;
                default:break;
                }
                
           switch(move2){
                case 0: player2[0] = pos[5];break;                              //se designa la posicion que va a tener el jugador 1
                case 1: player2[0] = pos[4];break;
                case 2: player2[0] = pos[3];break;
                case 3: player2[0] = pos[2];break;
                case 4: player2[0] = pos[1];break;
                case 5: player2[0] = pos[0];break;
                default:break;
                }
                
           status=4;
           }             
      if(status==4){
            switch(band){
          case 0: 
                 switch(fil){
                     case 7:
                        switch(col){
                            case 0:
                                  if(move1==0){band =2;}break;
                            case 1:
                                  if(move1==0){band = 2;}
                                  else if(move1==1){band =2;}break;
                            case 2:
                                  if(move1==0){band =1;}
                                  else if(move1==1){band =2;}
                                  else if(move1==2){band =2;}break;
                            case 3:
                                  if(move1==1){band=1;}
                                  else if(move1==2){band=2;}
                                  else if(move1==3){band=2;}break;
                            case 4:
                                  if(move1==2){band=1;}
                                  else if(move1==3){band=2;}
                                  else if(move1==4){band=2;}break;
                            case 5:
                                  if(move1==3){band=1;}
                                  else if(move1==4){band=2;}
                                  else if(move1==5){band=2;}break; 
                            case 6:
                                  if(move1==4){band=1;}
                                  else if(move1==5){band=2;}break;
                            case 7:
                                  if(move1==5){band=2;}break;
                                
                        }
                     //band = 1;break;
                     default: fil++; col++;break;
                     }break;
          case 1:
                 switch(col){
                     case 6:band = 2;break;
                     default: fil--; col++;break;
                     }break;
          case 2:
                 switch(fil){
                     case 3:
                           switch(col){
                            case 7:
                                  if(move2==0){band =0;}break;
                            case 6:
                                  if(move2==0){band = 0;}
                                  else if(move2==1){band =3;}break;
                            case 5:
                                  if(move2==0){band =0;}
                                  else if(move2==1){band =3;}
                                  else if(move2==2){band =3;}break;
                            case 4:
                                  if(move2==1){band=0;}
                                  else if(move2==2){band=3;}
                                  else if(move2==3){band=3;}break;
                            case 3:
                                  if(move2==2){band=0;}
                                  else if(move2==3){band=3;}
                                  else if(move2==4){band=3;}break;
                            case 2:
                                  if(move2==3){band=0;}
                                  else if(move2==4){band=3;}
                                  else if(move2==5){band=3;}break; 
                            case 1:
                                  if(move2==4){band=0;}
                                  else if(move2==5){band=3;}break;
                            case 0:
                                  if(move2==5){band=3;}break;
                                
                                }
                     //band = 3;break;
                     default: fil--;col--;break;
                     }break;
          case 3: 
                 switch(col){
                     case 0:band = 0;break;
                     default: fil++;col--;break;
                    }break;
          }
        status=5;
        }
        if(status==5){
            clr_vcol();
            sendSPI(8,player1[0]);
            sendSPI(1,player2[0]);
            sendSPI(fil,ball[col]);
            wait(0.2);
            status =0;
            }   
        }

 
}
