SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
float Vel=0.8;

void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock(); 
}

void printMatrix(uint8_t* vC, uint8_t col)
{
    int i;
    int j=1;
    int h=1;
    for(i=1;i<=8;i++){
         if(*(vC+1)==0b00000000 && *(vC)==0b00000000){
                sendSPI(i,*(vC+2)>>col-1); 
                if(i>0){
                sendSPI(i-1,0);
                }
                wait(Vel);   
                }
        else
        {          
        if(i>1){
        j=i-2;
        h=i-3;
        if(*(vC)==0b00000000){
                j=i-1;
                h=i;
                }     
        sendSPI(i,*(vC)>>col-1);
        sendSPI(j,*(vC+1)>>col-1);
        sendSPI(h,*(vC+2)>>col-1);
        if(i>2){
            sendSPI(i-3,0);
            }
        wait(Vel);
        } 
        }
        }
}

void giro(uint8_t *f,uint8_t col,uint8_t gi)
     {  
     uint8_t a[3]={0,0,0};
     int i;
     int j;
         switch(gi){    
         case 0:
         printMatrix(f,col);
         break;
         case 1:
         for(j=0;j<3;j++){
            for(i=0;i<3;i++){
             a[i]=((((*(f+j))<<2-i)&0b10000000)>>j)+a[i];
            }
         }   
         printMatrix(a,col);
         break;
         case 2:
         for(j=0;j<3;j++){
            for(i=0;i<3;i++){
             a[i]=((((*(f+(2-i)))>>2-j)&0b00100000)<<j)+a[i];
            }
            }
         printMatrix(a,col);
         break;
         case 3:
         for(j=0;j<3;j++){
            for(i=0;i<3;i++){
             a[i]=((((*(f+j))>>2-i)&(0b00100000))<<j)+a[i];
            }
          }   
         printMatrix(a,col);
         break;
         default:
         break;
         }     
     }
