#include "mbed.h"
#include "USBMIDI.h"
#include "MMA8451Q.h"
#include "TSISensor.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
USBMIDI midi;   // notes 48 al 82
DigitalOut myled(LED1);


void LLW_IRQHandler(void){
    if (LLWU->F2 & LLWU_F2_WUF11_MASK) {
       LLWU->F2 |= LLWU_F2_WUF11_MASK;   // write one to clear the flag
    }
}
 
void LLW_Init(void){
    LLWU->F2 |= LLWU_F2_WUF11_MASK;
    LLWU->PE3 = 0x80;
    LLWU->ME = 0x01;
}
 
void Enter_VLLS0(void){
       myled = 0;
    volatile unsigned int dummyread;
    int i;
    SMC->PMPROT = SMC_PMPROT_AVLLS_MASK;
    if ((SMC->PMSTAT & SMC_PMSTAT_PMSTAT_MASK)== 4){
        SMC->PMCTRL &= ~SMC_PMCTRL_RUNM_MASK;   // go back to RUN mode temporarily
         for (i=0;i<0xff;i++)
        {
            if ((SMC->PMSTAT & SMC_PMSTAT_PMSTAT_MASK)== 1)
                break;
        }
    }

  /* Set the STOPM field to 0b100 for VLLS0 mode */
  SMC->PMCTRL &= ~SMC_PMCTRL_STOPM_MASK; 
  SMC->PMCTRL |=  SMC_PMCTRL_STOPM(0x4); 
  /* set VLLSM = 00 * and PORPO = 1 */
  SMC->STOPCTRL &= ~SMC_STOPCTRL_VLLSM_MASK;
  SMC->STOPCTRL =  SMC_STOPCTRL_VLLSM(0) | SMC_STOPCTRL_PORPO_MASK;  
  /*wait for write to complete to SMC before stopping core */  
  dummyread = SMC->STOPCTRL;
  dummyread++;
  
    /* Now execute the stop instruction to go into VLLS0 */
    /* Set the SLEEPDEEP bit to enable deep sleep mode (STOP) */
    //SCB->SCR |= SCB_SCR_SLEEPDEEP_MASK;
    SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
    __wfi();
}

int main() {      

    float click =0;
    int16_t x = 0;
    int16_t z = 0;
    int16_t y = 0;
    TSISensor tsi;
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    NVIC_EnableIRQ(LLW_IRQn);
    
    while (1) {   
    
        x = -1*acc.getAccY();  
        y = 1*acc.getAccX();
        z = 1*acc.getAccZ();
        
        click=tsi.readPercentage();
        
          if (y>0) Enter_VLLS0();
          
          
        if (x>0){    
             if (click>0.70){
                midi.write(MIDIMessage::NoteOn(63));
                wait(0.25);
                midi.write(MIDIMessage::NoteOff(63));
                wait(0.5); 
             }
               
            if((click<0.70)&&(click>0.30)){
                midi.write(MIDIMessage::NoteOn(68));
                wait(0.25);
                midi.write(MIDIMessage::NoteOff(68));
                wait(0.5); 
             
             }
                
              if((click<0.30)&&(click>0)){
                midi.write(MIDIMessage::NoteOn(73));
                wait(0.25);
                midi.write(MIDIMessage::NoteOff(73));
                wait(0.5); 
             }
                    
        }
        wait(0.0001);
            
        
    }
    
}