#include "mbed.h"
#include "MobileLCD.h"

#define PI 3.1415926535897
MobileLCD lcd(5, 6, 7, 8, 9);
struct point
{
	int x;
	int y;
};

point points[3];
point current;

int main()
{
	for(int i=0; i<3; i++)
	{
		points[i].x = 65+60*sin(2*PI*i/3);
		points[i].y = 65+60*cos(2*PI*i/3);
	}
    lcd.background(0xFFFFFF);
    lcd.cls();
    current = points[rand()%3];
    while(1)
    {
        lcd.pixel(current.x, current.y, 0x000000);
        point nextpoint = points[rand()%3];
        current.x = (current.x + nextpoint.x)/2;
        current.y = (current.y + nextpoint.y)/2;
        wait(0.01);
    }
}