#include "mbed.h"
#include "MobileLCD.h"

#define PI 3.1415926535897
MobileLCD lcd(5, 6, 7, 8, 9);
DigitalIn Plus(20);
DigitalIn Minus(19);
AnalogIn Potent(18);
struct point
{
	int x;
	int y;
};

int numpoints = 10;
point points[256];

int main()
{
	while(1)
	{
		for(int i=0; i<numpoints; i++)
		{
			points[i].x = 65+60*sin(2*PI*i/numpoints);
			points[i].y = 65+60*cos(2*PI*i/numpoints);
		}
		lcd.background(0x0);
		lcd.cls();
		for(int i=0; i<numpoints; i++)
		{
			for(int j=i+1; j<numpoints; j++)
			{
				lcd.line(points[i].x,points[i].y,points[j].x,points[j].y,0xFFFFFF);
			}
		}
		/*
		while(1)
		{
			if(Plus && numpoints<256-1)
			{
				numpoints++;
				while(Plus);
				break;
			}
			else if(Minus && numpoints>3+1)
			{
				numpoints--;
				while(Minus);
				break;
			}
		}*/
		while(1)
		{
			float theta = Potent;
			if(abs(numpoints - theta*20)>1)
			{
				numpoints = ceil(theta*20);
				break;
			}
		}
    }
}