/* mbed Library - MobileLCD
 * Copyright (c) 2007/8, sford
 */

#ifndef MBED_MOBILELCD_H
#define MBED_MOBILELCD_H
 
#include "mbed.h"

namespace mbed {

class MobileLCD : public Stream {

public:

	MobileLCD(int mosi, int miso, int clk, int cs, int rst);

	virtual void reset();
	virtual void _select();
	virtual void _deselect();
	virtual void _window(int x, int y, int width, int height);
	virtual void _putp(int colour);
	virtual void orientation();

 	void command(int value);
 	void data(int value);
 	void foreground(int v);
 	void background(int v);
 	void locate(int column, int row);
 	void newline();
 	virtual int _putc(int c);
 	virtual int _getc() { return 0; }
	SPI _spi;
	DigitalOut _rst;
	DigitalOut _cs;	
	void bitblit(int x, int y, int width, int height, const char* bitstream);
	void fill(int x, int y, int width, int height, int colour);
	void blit(int x, int y, int width, int height, const int* colour);
	void cls();
	int width();
	int height();
	int columns();
	int rows();
	void putp(int v);
	void window(int x, int y, int width, int height);
	void pixel(int x, int y, int colour);
	void line(int x1, int y1, int x2, int y2, int colour);
	int _row, _column, _rows, _columns, _foreground, _background, _width, _height;
};

}

#endif
	

