#include "mbed.h"
#include "Matrix.h"

template <int WIDTH, int HEIGHT> class LEDMatrix : public Matrix<bool> {
  private:
    //Array of row pins
    DigitalOut* _rows;
    
    //Pointers to column control pins
    DigitalOut* _nextCol;
    DigitalOut* _firstCol;
    int _usPerColumn;
    
  public:
    LEDMatrix(DigitalOut rows[HEIGHT], DigitalOut* nextCol, DigitalOut* firstCol, int usPerFrame) : Matrix<bool>(WIDTH, HEIGHT), _rows(rows), _nextCol(nextCol), _firstCol(firstCol) { 
        clear();
        _usPerColumn = usPerFrame / WIDTH;
    }
    
    void redraw() {
        //Pulse firstCol
        *_firstCol = 1;
        wait_us(10);
        *_firstCol = 0;
        
        //Account for reverse column ordering
        for (int col = WIDTH - 1; col >= 0; col--) {
            //Pulse nextCol
            *_nextCol = 1;
            wait_us(10);
            *_nextCol = 0;
            
            //Output a column of data to the row pins.
            for(int row = 0; row < HEIGHT; row++) {
                _rows[row] = (*this)(col, row);
            }
            
            //Wait
            wait_us(_usPerColumn);
            
            //Clear the column, ready for the next iteration
            for(int i = 0; i < HEIGHT; i++) {
                _rows[i] = false;
            }
        }
    }
};