#ifndef LOCATIONS_H
#define LOCATIONS_H
template <typename T> class Location {
  public:
    T x, y;
    //Constructor
    Location(T x = 0, T y = 0) : x(x), y(y) { };
    
    //Equals operator
    bool operator==(Location<T> l) { return l.x == x && l.y == y; }
    
    //Addition operator
    Location<T> operator+(Location<T> l) { return Location<T>(l.x + x, l.y + y); }
    
    //Linerearly interpolate
    Location<T> lerp(Location<T> to, float alpha) {
        return Location<T>(
                   x*(1 - alpha) + to.x*alpha,
                   y*(1 - alpha) + to.y*alpha
               );
    }
    
    template <typename T2> operator Location<T2>();
};

//Convert from Location<int> to Location<float> and back
template <> Location<int>::operator Location<float>() {
    return Location<float>(x, y);
}
template <> Location<float>::operator Location<int>() {
    return Location<int>((int) (x + 0.5), (int) (y + 0.5));
}
#endif