#include "mbed.h"
#include "BitmapFile.h"
#include "MobileLCD.h"

LocalFileSystem local("local");
MobileLCD lcd(5, 6, 7, 8, 9);
Serial pc(USBTX,USBRX);

int main()
{
    BitmapFile MyBitmap("/local/mbed.bmp");
    int x = 3;
    int y = 3;
    unsigned int color = MyBitmap.getPixel(x,y);
    lcd.background(0xFF0000);
    lcd.cls();
    lcd.printf("Offset = %X",MyBitmap.getOffset());
    lcd.newline();
    lcd.printf("Header = %d",MyBitmap.getHeaderType());
    lcd.newline();
    lcd.printf("Color depth = %d",MyBitmap.getColorDepth());
    lcd.newline();
    lcd.printf("Size = %d x %d",MyBitmap.getWidth(),MyBitmap.getHeight());
    lcd.newline();
    lcd.printf("Rowlength = %d",MyBitmap.getRowSize());
    lcd.newline();
    lcd.printf("(%d,%d) = %06X",x,y,MyBitmap.getPixel(x,y));//<----
    lcd.newline();
    wait(3);
    lcd.background(0x8f8f8f);
    lcd.cls();
	lcd.background(0x000000);
	lcd.cls();
	
	for(int row = 0; row < MyBitmap.getHeight(); row++)
	{
		
		//int *colors = MyBitmap.getRow(row,false);
		//lcd.blit(0,MyBitmap.getHeight()-row-1,MyBitmap.getWidth(),1,colors);
		//delete [] colors;
		char *bitstream = MyBitmap.getRowBitstream(row,false);
		lcd.bitblit(0,MyBitmap.getHeight()-row-1,MyBitmap.getWidth(),1,bitstream);
		delete [] bitstream;
	}
	MyBitmap.close();
}
